/****************************************************************************
 *                             VVPRemoteSim.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements the VVP RemoteSim interface
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_VVP_REMOTE_SIM_H
#define INCLUDED_VVP_REMOTE_SIM_H
#include "IviRemoteSim.h"
#include "ivi_String.h"

/********************************************************************/
/** \class VVPRemoteSim
 *  \brief Implements the VVP RemoteSim interface
 ********************************************************************/
class VVPRemoteSim : public IviRemoteSim {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * VVPRemoteSim()
         */
        /** 
         ************************************************************/
         VVPRemoteSim(Tcl_Interp *interp, int argc, char **argv);

        /************************************************************
         * ~VVPRemoteSim()
         */
        /**
         ************************************************************/
         virtual ~VVPRemoteSim();

        /************************************************************
         * LoadDesign()
         */
        /** Called by the base-class when a design is loaded to the
         *  simulator instance. In the case of the VVP simulator, 
         *  LoadDesign causes the simulator to be started
         ************************************************************/
        virtual int LoadDesign(char *design_path);

};

#endif /* INCLUDED_VVP_REMOTE_SIM_H */
