PREFIX=/usr/local
PROJECT=ivritex
VERSION=1.1.0
TEX_ROOT=$(PREFIX)/share/texmf
HEBBIB_SUBDIR=bibtex/ivritex
IVRITEX_BIBDIR=$(TEX_ROOT)/$(HEBBIB_SUBDIR)
# for the moment still put things in a seperate subdir.
# tetex seems to already include hebrew.sty in the babel directory
IVRITEX_DIR=0ivritex
HEBLATEX_SUBDIR=tex/generic/$(IVRITEX_DIR)
HEBLATEX_DOC_SUBDIR=doc/generic/$(IVRITEX_DIR)
HEBREW_TARGET_DIR=$(TEX_ROOT)/$(HEBLATEX_SUBDIR)
HEBREW_TARGET_DOC_DIR=$(TEX_ROOT)/$(HEBLATEX_DOC_SUBDIR)
LATEX=elatex
RM=rm -f
TEX_REHASH=mktexlsr
DVIPS=dvips
PS2PDF=ps2pdf

CONFIG_MAKEFILE=ivritex.mk

RPM_SPEC=$(PROJECT).spec
FILES_LIST_FILE=files_list 
GENERATED_FILES=$(RPM_SPEC) $(FILES_LIST_FILE)

FILES_LIST=$(GENERATED_FILES) $(shell cat $(FILES_LIST_FILE)) 

#as=`kpsewhich --expand-path \\$$TEXMF`
#old_texmf=`kpsewhich --expand-path $$TEXMF`
#ADD_TO_TEXMF=`pwd`/latex/heblatex:`pwd`/fonts
#export TEXMF=$(ADD_TO_TEXMF):$(old_texmf)
#export TEXMF=$(old_texmf)

TAR=tar
CVS=cvs
SED=sed
CP=cp
RM=rm -f
MKDIR=mkdir
DIRNAME=dirname
GREP=grep

TAR_BALL_DIR=$(PROJECT)-$(VERSION)
TAR_BALL=$(PROJECT)-$(VERSION).tar.gz

EXAMPLES=$(TEX_SRC:%=%.dvi) $(TEX_SRC:%=%.ps) $(TEX_SRC:%=%.pdf)
TARGETS+=$(EXAMPLES)
CLEAN+=$(TEX_SRC:%=%.log) $(TEX_SRC:%=%.aux) $(TEX_SRC:%=%.toc) \
       $(EXAMPLES) missfont.log

all: all_subdirs $(TARGETS)

clean: clean_subdirs
	rm -f $(CLEAN)

install: copy_only
	$(TEXREHASH)

copy_only: install_subdirs do_install

ifeq ($(SUBDIRS),)
# if SUBDIRS is not defined those targets should do nothing:
clean_subdirs:
all_subdirs:
install_subdirs:

else

clean_subdirs: $(SUBDIRS)
	@for dir in $(SUBDIRS); do make -C $$dir clean; done

all_subdirs: $(SUBDIRS)
	@for dir in $(SUBDIRS); do make -C $$dir all; done
	
install_subdirs: $(SUBDIRS)
	@for dir in $(SUBDIRS); do make -C $$dir copy_only; done
endif

%.dvi: %.dtx
	$(LATEX) $<
	#makeindex -s bbind.ist hebrew.idx
	#makeindex -s bbglo.ist -o hebrew.gls hebrew.glo
	$(LATEX) $<
	$(LATEX) $<

%.dvi: %.tex
	$(LATEX) $<
	$(LATEX) $<
	$(LATEX) $<

%.ps: %.dvi
	$(DVIPS) -o $@ $<

%.pdf: %.ps
	$(PS2PDF) $< $@
