#ifndef _CLIENT_C
#define _CLIENT_C

#include <string.h>
#include "memory.c"
#include "network.c"

typedef struct 
{
  struct sockaddr_in address ;
  int32_t mask ;
  int8_t in_use ;
} 
client_t ;

typedef struct 
{
  client_t *c ;
  int n ;
} 
client_register_t ;

client_register_t *
alloc_client_register ( int n )
{
  client_register_t *r = xmalloc ( sizeof(client_register_t) ) ;
  r->n = n ;
  r->c = xmalloc ( n * sizeof(client_t) ) ;
  int i ;
  for ( i = 0 ; i < r->n ; i++ ) {
    r->c[i].in_use = 0 ;
    r->c[i].mask = 0 ;
  }
  return r ;
}

void
free_client_register ( client_register_t *r ) 
{
  free ( r->c ) ;
  free ( r ) ;
}

void
edit_client_register ( client_register_t *r , struct sockaddr_in addr , int mask ) 
{
  int i ;
  for ( i = 0 ; i < r->n ; i++ ) {
    if ( r->c[i].in_use && sockaddr_in_equal ( &addr , &(r->c[i].address) ) ) {
      if ( mask < 0 ) {
	r->c[i].in_use = 0 ;
	r->c[i].mask = 0 ;
      } else {
	r->c[i].mask = mask ;
      }
      return ;
    }
  }
  if ( mask < 0 ) {
    fprintf ( stderr , "edit_client_register: unregister request for unregistered client\n" ) ;
    return ;
  }
  for ( i = 0 ; i < r->n ; i++ ) {
    if ( ! r->c[i].in_use ) {
      memcpy ( &(r->c[i].address) , &addr , sizeof(addr) ) ;
      r->c[i].mask = mask ;
      r->c[i].in_use = 1 ;
      return ;
    }
  }
  fprintf ( stderr , "edit_client_register: client dropped, too many clients\n" ) ;
}

void
sendto_client_register ( int fd , const client_register_t *r , const char *packet , int packet_sz , int mask ) 
{
  if ( packet_sz ) {
    int i ;
    for ( i = 0 ; i < r->n ; i++ ) {
      if ( r->c[i].in_use && ( r->c[i].mask & mask ) ) {
        sendto_exactly ( fd , packet , packet_sz , r->c[i].address ) ;
      }
    }
  }
}

#endif
