/*
 * $Id: tcplog.h,v 1.5 1998/08/03 14:09:36 ams Exp $
 * Copyright 1998 ams@wiw.org (Abhijit Menon-Sen)
 */

#include "common.h"

#if defined(__GLIBC__) && (__GLIBC__ >= 2)
#include <netinet/tcp.h>
#else
#include <linux/tcp.h>
#endif

char *version = "tcplog " VERSION ", ams@wiw.org";
char *cfgfile = TCPLOG_CONF;

/* convert IP addresses to hostnames? */
short int resolve_names = 1;

/* default log level */
short int lvl = LOG_WARNING;

/* default logging facility */
short int fac = LOG_DAEMON;

/* TCP packet */
typedef struct {
    struct iphdr ip;
    struct tcphdr tcp;
    char data[0];
} tcppkt;

/* service list */
char *ports[1024];
