#!/bin/sh
set -e

PACKAGE=$(dpkg-parsechangelog -S Source)
VERSION=$2
DIR=${PACKAGE}-${VERSION}
TAR=../${PACKAGE}_${VERSION}.orig.tar.xz

rm $3
git clone --branch ${VERSION} git://java.net/jax-rs-spec~api $DIR

XZ_OPT=--best tar -c -v -J -f $TAR \
    --exclude '.git' \
    --exclude 'src/examples' \
    --exclude 'spec' \
    $DIR
rm -Rf $DIR
