/* 
    * $id:jalali.h - Jalali Calendar
    * Tools for converting Jalali to Gregorian dates and vice-versa.
    * Copyright (C) 2006, 2007 Ashkan Ghassemi  
    * 
    * This program is free software; you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation; either version 2 of the License, or
    * (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License along
    * with this program; if not, write to the Free Software Foundation, Inc.,
    * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/ 

#include "config.h"

#ifndef __JALALI_H
#define __JALALI_H

/* 
 * Uncomment the following line the enable debugging options for jalali.c 
 */

// #define __WDEBUG

struct j_date_ {
    int year ;
    int month ;
    int day ;
    int wday ;
    int today ;
};

typedef struct j_date_ j_date ;

int is_jleap(int) ;
int is_gleap(int) ;
int get_last_jleap(int) ;
int get_last_gleap(int) ;
int convert_to_jalali(long, j_date*) ;
int get_week_day(int, int, int) ;

#endif /* __JALALI_H */
