/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Javadoc
extends Task {
    private Commandline cmd = new Commandline();
    private static boolean javadoc1 = Project.getJavaVersion() == "1.1";
    private boolean foundJavaFile = false;
    private boolean failOnError = false;
    private Path sourcePath = null;
    private File destDir = null;
    private Vector sourceFiles = new Vector();
    private Vector packageNames = new Vector(5);
    private Vector excludePackageNames = new Vector(1);
    private boolean author = true;
    private boolean version = true;
    private DocletInfo doclet = null;
    private Path classpath = null;
    private Path bootclasspath = null;
    private String group = null;
    private Vector compileList = new Vector(10);
    private String packageList = null;
    private Vector links = new Vector(2);
    private Vector groups = new Vector(2);
    private boolean useDefaultExcludes = true;
    private Html doctitle = null;
    private Html header = null;
    private Html footer = null;
    private Html bottom = null;
    private boolean useExternalFile = false;
    private File tmpList = null;

    private void addArgIf(boolean bl, String string) {
        if (bl) {
            this.cmd.createArgument().setValue(string);
        }
    }

    private void add12ArgIfNotEmpty(String string, String string2) {
        if (!javadoc1) {
            if (string2 != null && string2.length() != 0) {
                this.cmd.createArgument().setValue(string);
                this.cmd.createArgument().setValue(string2);
            } else {
                this.project.log(this, "Warning: Leaving out empty argument '" + string + "'", 1);
            }
        }
    }

    private void add11ArgIf(boolean bl, String string) {
        if (javadoc1 && bl) {
            this.cmd.createArgument().setValue(string);
        }
    }

    private void add12ArgIf(boolean bl, String string) {
        if (!javadoc1 && bl) {
            this.cmd.createArgument().setValue(string);
        }
    }

    public void setUseExternalFile(boolean bl) {
        if (!javadoc1) {
            this.useExternalFile = bl;
        }
    }

    public void setDefaultexcludes(boolean bl) {
        this.useDefaultExcludes = bl;
    }

    public void setMaxmemory(String string) {
        if (javadoc1) {
            this.cmd.createArgument().setValue("-J-mx" + string);
        } else {
            this.cmd.createArgument().setValue("-J-Xmx" + string);
        }
    }

    public void setAdditionalparam(String string) {
        this.cmd.createArgument().setLine(string);
    }

    public void setSourcepath(Path path) {
        if (this.sourcePath == null) {
            this.sourcePath = path;
        } else {
            this.sourcePath.append(path);
        }
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.project);
        }
        return this.sourcePath.createPath();
    }

    public void setSourcepathRef(Reference reference) {
        this.createSourcepath().setRefid(reference);
    }

    public void setDestdir(File file) {
        this.destDir = file;
        this.cmd.createArgument().setValue("-d");
        this.cmd.createArgument().setFile(this.destDir);
    }

    public void setSourcefiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            SourceFile sourceFile = new SourceFile();
            sourceFile.setFile(this.project.resolveFile(string2));
            this.addSource(sourceFile);
        }
    }

    public void addSource(SourceFile sourceFile) {
        this.sourceFiles.addElement(sourceFile);
    }

    public void setPackagenames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            PackageName packageName = new PackageName();
            packageName.setName(string2);
            this.addPackage(packageName);
        }
    }

    public void addPackage(PackageName packageName) {
        this.packageNames.addElement(packageName);
    }

    public void setExcludePackageNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            PackageName packageName = new PackageName();
            packageName.setName(string2);
            this.addExcludePackage(packageName);
        }
    }

    public void addExcludePackage(PackageName packageName) {
        this.excludePackageNames.addElement(packageName);
    }

    public void setOverview(File file) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-overview");
            this.cmd.createArgument().setFile(file);
        }
    }

    public void setPublic(boolean bl) {
        this.addArgIf(bl, "-public");
    }

    public void setProtected(boolean bl) {
        this.addArgIf(bl, "-protected");
    }

    public void setPackage(boolean bl) {
        this.addArgIf(bl, "-package");
    }

    public void setPrivate(boolean bl) {
        this.addArgIf(bl, "-private");
    }

    public void setAccess(AccessType accessType) {
        this.cmd.createArgument().setValue("-" + accessType.getValue());
    }

    public void setDoclet(String string) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.setName(string);
    }

    public void setDocletPath(Path path) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.setPath(path);
    }

    public void setDocletPathRef(Reference reference) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.createPath().setRefid(reference);
    }

    public DocletInfo createDoclet() {
        this.doclet = new DocletInfo();
        return this.doclet;
    }

    public void setOld(boolean bl) {
        this.add12ArgIf(bl, "-1.1");
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setBootclasspath(Path path) {
        if (this.bootclasspath == null) {
            this.bootclasspath = path;
        } else {
            this.bootclasspath.append(path);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.project);
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference reference) {
        this.createBootclasspath().setRefid(reference);
    }

    public void setExtdirs(String string) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-extdirs");
            this.cmd.createArgument().setValue(string);
        }
    }

    public void setVerbose(boolean bl) {
        this.add12ArgIf(bl, "-verbose");
    }

    public void setLocale(String string) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-locale");
            this.cmd.createArgument().setValue(string);
        }
    }

    public void setEncoding(String string) {
        this.cmd.createArgument().setValue("-encoding");
        this.cmd.createArgument().setValue(string);
    }

    public void setVersion(boolean bl) {
        this.version = bl;
    }

    public void setUse(boolean bl) {
        this.add12ArgIf(bl, "-use");
    }

    public void setAuthor(boolean bl) {
        this.author = bl;
    }

    public void setSplitindex(boolean bl) {
        this.add12ArgIf(bl, "-splitindex");
    }

    public void setWindowtitle(String string) {
        this.add12ArgIfNotEmpty("-windowtitle", string);
    }

    public void setDoctitle(String string) {
        Html html = new Html();
        html.addText(string);
        this.addDoctitle(html);
    }

    public void addDoctitle(Html html) {
        if (!javadoc1) {
            this.doctitle = html;
        }
    }

    public void setHeader(String string) {
        Html html = new Html();
        html.addText(string);
        this.addHeader(html);
    }

    public void addHeader(Html html) {
        if (!javadoc1) {
            this.header = html;
        }
    }

    public void setFooter(String string) {
        Html html = new Html();
        html.addText(string);
        this.addFooter(html);
    }

    public void addFooter(Html html) {
        if (!javadoc1) {
            this.footer = html;
        }
    }

    public void setBottom(String string) {
        Html html = new Html();
        html.addText(string);
        this.addBottom(html);
    }

    public void addBottom(Html html) {
        if (!javadoc1) {
            this.bottom = html;
        }
    }

    public void setLinkoffline(String string) {
        if (!javadoc1) {
            LinkArgument linkArgument = this.createLink();
            linkArgument.setOffline(true);
            String string2 = "The linkoffline attribute must include a URL and a package-list file location separated by a space";
            if (string.trim().length() == 0) {
                throw new BuildException(string2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
            linkArgument.setHref(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) {
                throw new BuildException(string2);
            }
            linkArgument.setPackagelistLoc(this.project.resolveFile(stringTokenizer.nextToken()));
        }
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setLink(String string) {
        if (!javadoc1) {
            this.createLink().setHref(string);
        }
    }

    public void setNodeprecated(boolean bl) {
        this.addArgIf(bl, "-nodeprecated");
    }

    public void setNodeprecatedlist(boolean bl) {
        this.add12ArgIf(bl, "-nodeprecatedlist");
    }

    public void setNotree(boolean bl) {
        this.addArgIf(bl, "-notree");
    }

    public void setNoindex(boolean bl) {
        this.addArgIf(bl, "-noindex");
    }

    public void setNohelp(boolean bl) {
        this.add12ArgIf(bl, "-nohelp");
    }

    public void setNonavbar(boolean bl) {
        this.add12ArgIf(bl, "-nonavbar");
    }

    public void setSerialwarn(boolean bl) {
        this.add12ArgIf(bl, "-serialwarn");
    }

    public void setStylesheetfile(File file) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-stylesheetfile");
            this.cmd.createArgument().setFile(file);
        }
    }

    public void setHelpfile(File file) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-helpfile");
            this.cmd.createArgument().setFile(file);
        }
    }

    public void setDocencoding(String string) {
        this.cmd.createArgument().setValue("-docencoding");
        this.cmd.createArgument().setValue(string);
    }

    public void setPackageList(String string) {
        this.packageList = string;
    }

    public LinkArgument createLink() {
        LinkArgument linkArgument = new LinkArgument();
        this.links.addElement(linkArgument);
        return linkArgument;
    }

    public GroupArgument createGroup() {
        GroupArgument groupArgument = new GroupArgument();
        this.groups.addElement(groupArgument);
        return groupArgument;
    }

    public void setCharset(String string) {
        this.add12ArgIfNotEmpty("-charset", string);
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Object object;
        Object object2;
        block58: {
            Object object3;
            Object object4;
            if ("javadoc2".equals(this.taskType)) {
                this.log("!! javadoc2 is deprecated. Use javadoc instead. !!");
            }
            if (this.sourcePath == null) {
                String string = "sourcePath attribute must be set!";
                throw new BuildException(string);
            }
            this.log("Generating Javadoc", 2);
            if (this.doctitle != null) {
                this.cmd.createArgument().setValue("-doctitle");
                this.cmd.createArgument().setValue(this.expand(this.doctitle.getText()));
            }
            if (this.header != null) {
                this.cmd.createArgument().setValue("-header");
                this.cmd.createArgument().setValue(this.expand(this.header.getText()));
            }
            if (this.footer != null) {
                this.cmd.createArgument().setValue("-footer");
                this.cmd.createArgument().setValue(this.expand(this.footer.getText()));
            }
            if (this.bottom != null) {
                this.cmd.createArgument().setValue("-bottom");
                this.cmd.createArgument().setValue(this.expand(this.bottom.getText()));
            }
            Commandline commandline = (Commandline)this.cmd.clone();
            commandline.setExecutable(this.getJavadocExecutableName());
            this.classpath = this.classpath == null ? Path.systemClasspath : this.classpath.concatSystemClasspath("ignore");
            if (!javadoc1) {
                commandline.createArgument().setValue("-classpath");
                commandline.createArgument().setPath(this.classpath);
                commandline.createArgument().setValue("-sourcepath");
                commandline.createArgument().setPath(this.sourcePath);
            } else {
                commandline.createArgument().setValue("-classpath");
                commandline.createArgument().setValue(this.sourcePath.toString() + System.getProperty("path.separator") + this.classpath.toString());
            }
            if (this.version && this.doclet == null) {
                commandline.createArgument().setValue("-version");
            }
            if (this.author && this.doclet == null) {
                commandline.createArgument().setValue("-author");
            }
            if ((javadoc1 || this.doclet == null) && this.destDir == null) {
                String string = "destDir attribute must be set!";
                throw new BuildException(string);
            }
            if (!javadoc1) {
                if (this.doclet != null) {
                    if (this.doclet.getName() == null) {
                        throw new BuildException("The doclet name must be specified.", this.location);
                    }
                    commandline.createArgument().setValue("-doclet");
                    commandline.createArgument().setValue(this.doclet.getName());
                    if (this.doclet.getPath() != null) {
                        commandline.createArgument().setValue("-docletpath");
                        commandline.createArgument().setPath(this.doclet.getPath());
                    }
                    object2 = this.doclet.getParams();
                    while (object2.hasMoreElements()) {
                        object = (DocletParam)object2.nextElement();
                        if (((DocletParam)object).getName() == null) {
                            throw new BuildException("Doclet parameters must have a name");
                        }
                        commandline.createArgument().setValue(((DocletParam)object).getName());
                        if (((DocletParam)object).getValue() == null) continue;
                        commandline.createArgument().setValue(((DocletParam)object).getValue());
                    }
                }
                if (this.bootclasspath != null) {
                    commandline.createArgument().setValue("-bootclasspath");
                    commandline.createArgument().setPath(this.bootclasspath);
                }
                if (this.links.size() != 0) {
                    object2 = this.links.elements();
                    while (object2.hasMoreElements()) {
                        object = (LinkArgument)object2.nextElement();
                        if (((LinkArgument)object).getHref() == null) {
                            throw new BuildException("Links must provide the URL to the external class documentation.");
                        }
                        if (((LinkArgument)object).isLinkOffline()) {
                            object4 = ((LinkArgument)object).getPackagelistLoc();
                            if (object4 == null) {
                                throw new BuildException("The package list location for link " + ((LinkArgument)object).getHref() + " must be provided because the link is offline");
                            }
                            object3 = new File((File)object4, "package-list");
                            if (((File)object3).exists()) {
                                commandline.createArgument().setValue("-linkoffline");
                                commandline.createArgument().setValue(((LinkArgument)object).getHref());
                                commandline.createArgument().setValue(((File)object4).getAbsolutePath());
                                continue;
                            }
                            this.log("Warning: No package list was found at " + object4, 3);
                            continue;
                        }
                        commandline.createArgument().setValue("-link");
                        commandline.createArgument().setValue(((LinkArgument)object).getHref());
                    }
                }
                if (this.group != null) {
                    object2 = new StringTokenizer(this.group, ",", false);
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken().trim();
                        int n = ((String)object).indexOf(" ");
                        if (n <= 0) continue;
                        object3 = ((String)object).substring(0, n);
                        String string = ((String)object).substring(n + 1);
                        commandline.createArgument().setValue("-group");
                        commandline.createArgument().setValue((String)object3);
                        commandline.createArgument().setValue(string);
                    }
                }
                if (this.groups.size() != 0) {
                    object2 = this.groups.elements();
                    while (object2.hasMoreElements()) {
                        object = (GroupArgument)object2.nextElement();
                        object4 = ((GroupArgument)object).getTitle();
                        object3 = ((GroupArgument)object).getPackages();
                        if (object4 == null) throw new BuildException("The title and packages must be specified for group elements.");
                        if (object3 == null) {
                            throw new BuildException("The title and packages must be specified for group elements.");
                        }
                        commandline.createArgument().setValue("-group");
                        commandline.createArgument().setValue(this.expand((String)object4));
                        commandline.createArgument().setValue((String)object3);
                    }
                }
            }
            this.tmpList = null;
            if (this.packageNames.size() > 0) {
                block57: {
                    object2 = new Vector();
                    object = this.packageNames.elements();
                    while (true) {
                        if (!object.hasMoreElements()) {
                            object4 = new Vector();
                            if (this.excludePackageNames.size() > 0) {
                                object = this.excludePackageNames.elements();
                                break;
                            }
                            break block57;
                        }
                        object4 = (PackageName)object.nextElement();
                        object3 = ((PackageName)object4).getName().trim();
                        if (((String)object3).endsWith(".*")) {
                            ((Vector)object2).addElement(object3);
                            continue;
                        }
                        commandline.createArgument().setValue((String)object3);
                    }
                    while (object.hasMoreElements()) {
                        object3 = (PackageName)object.nextElement();
                        ((Vector)object4).addElement(((PackageName)object3).getName().trim());
                    }
                }
                if (((Vector)object2).size() > 0) {
                    this.evaluatePackages(commandline, this.sourcePath, (Vector)object2, (Vector)object4);
                }
            }
            if (this.sourceFiles.size() > 0) {
                object2 = null;
                try {
                    try {
                        if (this.useExternalFile) {
                            if (this.tmpList == null) {
                                this.tmpList = this.createTempFile();
                                commandline.createArgument().setValue("@" + this.tmpList.getAbsolutePath());
                            }
                            object2 = new PrintWriter(new FileWriter(this.tmpList.getAbsolutePath(), true));
                        }
                        object = this.sourceFiles.elements();
                        while (object.hasMoreElements()) {
                            object4 = (SourceFile)object.nextElement();
                            object3 = ((SourceFile)object4).getFile().getAbsolutePath();
                            if (this.useExternalFile) {
                                ((PrintWriter)object2).println((String)object3);
                                continue;
                            }
                            commandline.createArgument().setValue((String)object3);
                        }
                    }
                    catch (IOException iOException) {
                        throw new BuildException("Error creating temporary file", iOException, this.location);
                    }
                    Object var8_13 = null;
                    if (object2 != null) {
                        ((PrintWriter)object2).close();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    if (object2 == null) throw throwable;
                    ((PrintWriter)object2).close();
                    throw throwable;
                }
            }
            if (this.packageList != null) {
                commandline.createArgument().setValue("@" + this.packageList);
            }
            this.log("Javadoc args: " + commandline, 3);
            this.log("Javadoc execution", 2);
            object2 = new JavadocOutputStream(2);
            object = new JavadocOutputStream(1);
            object4 = new Execute(new PumpStreamHandler((OutputStream)object2, (OutputStream)object));
            ((Execute)object4).setAntRun(this.project);
            ((Execute)object4).setWorkingDirectory(null);
            try {
                try {
                    ((Execute)object4).setCommandline(commandline.getCommandline());
                    int n = ((Execute)object4).execute();
                    if (n != 0 && this.failOnError) {
                        throw new BuildException("Javadoc returned " + n, this.location);
                    }
                    Object var10_16 = null;
                    if (this.tmpList == null) break block58;
                    this.tmpList.delete();
                }
                catch (IOException iOException) {
                    throw new BuildException("Javadoc failed: " + iOException, iOException, this.location);
                }
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                if (this.tmpList != null) {
                    this.tmpList.delete();
                    this.tmpList = null;
                }
                ((JavadocOutputStream)object2).logFlush();
                ((JavadocOutputStream)object).logFlush();
                try {
                    ((LogOutputStream)object2).close();
                    ((LogOutputStream)object).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            this.tmpList = null;
        }
        ((JavadocOutputStream)object2).logFlush();
        ((JavadocOutputStream)object).logFlush();
        try {}
        catch (IOException iOException) {}
        ((LogOutputStream)object2).close();
        ((LogOutputStream)object).close();
        return;
    }

    private void evaluatePackages(Commandline commandline, Path path, Vector vector, Vector vector2) {
        Object object;
        this.log("Source path = " + path.toString(), 3);
        StringBuffer stringBuffer = new StringBuffer("Packages = ");
        int n = 0;
        while (n < vector.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(vector.elementAt(n));
            ++n;
        }
        this.log(stringBuffer.toString(), 3);
        stringBuffer.setLength(0);
        stringBuffer.append("Exclude Packages = ");
        int n2 = 0;
        while (n2 < vector2.size()) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(vector2.elementAt(n2));
            ++n2;
        }
        this.log(stringBuffer.toString(), 3);
        Vector<String> vector3 = new Vector<String>();
        String[] stringArray = path.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        FileSet fileSet = new FileSet();
        fileSet.setDefaultexcludes(this.useDefaultExcludes);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)(object = ((String)object).replace('.', '/'))).endsWith("*")) {
                object = (String)object + "*";
            }
            fileSet.createInclude().setName((String)object);
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)(object = ((String)object).replace('.', '/'))).endsWith("*")) {
                object = (String)object + "*";
            }
            fileSet.createExclude().setName((String)object);
        }
        object = null;
        try {
            try {
                if (this.useExternalFile) {
                    this.tmpList = this.createTempFile();
                    commandline.createArgument().setValue("@" + this.tmpList.getAbsolutePath());
                    object = new PrintWriter(new FileWriter(this.tmpList));
                }
                int n3 = 0;
                while (n3 < stringArray.length) {
                    File file = this.project.resolveFile(stringArray[n3]);
                    fileSet.setDir(file);
                    DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
                    String[] stringArray2 = directoryScanner.getIncludedDirectories();
                    int n4 = 0;
                    while (n4 < stringArray2.length) {
                        String string;
                        File file2 = new File(file, stringArray2[n4]);
                        String[] stringArray3 = file2.list(new FilenameFilter(){

                            public boolean accept(File file, String string) {
                                return string.endsWith(".java");
                            }
                        });
                        if (stringArray3.length > 0 && !vector3.contains(string = stringArray2[n4].replace('/', '.').replace('\\', '.'))) {
                            if (this.useExternalFile) {
                                ((PrintWriter)object).println(string);
                            } else {
                                commandline.createArgument().setValue(string);
                            }
                            vector3.addElement(string);
                        }
                        ++n4;
                    }
                    ++n3;
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Error creating temporary file", iOException, this.location);
            }
            Object var22_22 = null;
            if (object != null) {
                ((PrintWriter)object).close();
            }
        }
        catch (Throwable throwable) {
            Object var22_23 = null;
            if (object != null) {
                ((PrintWriter)object).close();
            }
            throw throwable;
        }
    }

    protected String expand(String string) {
        return ProjectHelper.replaceProperties(this.project, string, this.project.getProperties());
    }

    private File createTempFile() {
        return new File("javadoc" + new Random(System.currentTimeMillis()).nextLong());
    }

    private String getJavadocExecutableName() {
        String string = System.getProperty("os.name").toLowerCase();
        boolean bl = string.indexOf("windows") >= 0 || string.indexOf("os/2") >= 0;
        String string2 = bl ? ".exe" : "";
        File file = new File(System.getProperty("java.home") + "/../bin/javadoc" + string2);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        this.log("Unable to locate " + file.getAbsolutePath() + ". Using \"javadoc\" instead.", 3);
        return "javadoc";
    }

    private class JavadocOutputStream
    extends LogOutputStream {
        private String queuedLine = null;

        JavadocOutputStream(int n) {
            super(Javadoc.this, n);
        }

        protected void processLine(String string, int n) {
            if (n == 2 && string.startsWith("Generating ")) {
                if (this.queuedLine != null) {
                    super.processLine(this.queuedLine, 3);
                }
                this.queuedLine = string;
            } else {
                if (this.queuedLine != null) {
                    if (string.startsWith("Building ")) {
                        super.processLine(this.queuedLine, 3);
                    } else {
                        super.processLine(this.queuedLine, 2);
                    }
                    this.queuedLine = null;
                }
                super.processLine(string, n);
            }
        }

        protected void logFlush() {
            if (this.queuedLine != null) {
                super.processLine(this.queuedLine, 3);
                this.queuedLine = null;
            }
        }
    }

    public class GroupArgument {
        private Html title;
        private Vector packages = new Vector(3);

        public void setTitle(String string) {
            Html html = new Html();
            html.addText(string);
            this.addTitle(html);
        }

        public void addTitle(Html html) {
            this.title = html;
        }

        public String getTitle() {
            return this.title != null ? this.title.getText() : null;
        }

        public void setPackages(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                PackageName packageName = new PackageName();
                packageName.setName(string2);
                this.addPackage(packageName);
            }
        }

        public void addPackage(PackageName packageName) {
            this.packages.addElement(packageName);
        }

        public String getPackages() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.packages.size()) {
                if (n > 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append(this.packages.elementAt(n).toString());
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    public class LinkArgument {
        private String href;
        private boolean offline = false;
        private File packagelistLoc;

        public void setHref(String string) {
            this.href = string;
        }

        public String getHref() {
            return this.href;
        }

        public void setPackagelistLoc(File file) {
            this.packagelistLoc = file;
        }

        public File getPackagelistLoc() {
            return this.packagelistLoc;
        }

        public void setOffline(boolean bl) {
            this.offline = bl;
        }

        public boolean isLinkOffline() {
            return this.offline;
        }
    }

    public static class AccessType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"protected", "public", "package", "private"};
        }
    }

    public static class Html {
        private StringBuffer text = new StringBuffer();

        public void addText(String string) {
            this.text.append(string);
        }

        public String getText() {
            return this.text.toString();
        }
    }

    public static class SourceFile {
        private File file;

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static class PackageName {
        private String name;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public class DocletInfo {
        private String name;
        private Path path;
        private Vector params = new Vector();

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setPath(Path path) {
            if (this.path == null) {
                this.path = path;
            } else {
                this.path.append(path);
            }
        }

        public Path getPath() {
            return this.path;
        }

        public Path createPath() {
            if (this.path == null) {
                this.path = new Path(Javadoc.this.getProject());
            }
            return this.path.createPath();
        }

        public void setPathRef(Reference reference) {
            this.createPath().setRefid(reference);
        }

        public DocletParam createParam() {
            DocletParam docletParam = new DocletParam();
            this.params.addElement(docletParam);
            return docletParam;
        }

        public Enumeration getParams() {
            return this.params.elements();
        }
    }

    public class DocletParam {
        private String name;
        private String value;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }
    }
}

