/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class Zip
extends MatchingTask {
    private File zipFile;
    private File baseDir;
    private boolean doCompress = true;
    private boolean doUpdate = false;
    private boolean doFilesonly = false;
    protected String archiveType = "zip";
    private static long emptyCrc = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private Vector filesets = new Vector();
    private Hashtable addedDirs = new Hashtable();
    private Vector addedFiles = new Vector();
    private boolean addingNewFiles;
    private String encoding = null;

    public void setZipfile(File file) {
        this.zipFile = file;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setCompress(boolean bl) {
        this.doCompress = bl;
    }

    public void setFilesonly(boolean bl) {
        this.doFilesonly = bl;
    }

    public void setUpdate(boolean bl) {
        this.doUpdate = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addZipfileset(ZipFileSet zipFileSet) {
        this.filesets.addElement(zipFileSet);
    }

    public void setWhenempty(WhenEmpty whenEmpty) {
        this.emptyBehavior = whenEmpty.getValue();
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    /*
     * Unable to fully structure code
     */
    public void execute() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        var1_1 = null;
        this.addingNewFiles = true;
        var2_2 = false;
        if (this.doUpdate && this.zipFile.exists()) {
            var2_2 = true;
            var3_3 = 0;
            while (var3_3 < 1000) {
                var1_1 = new File(this.zipFile.getParent(), "tmp." + var3_3);
                if (!var1_1.exists()) break;
                ++var3_3;
            }
            if (var3_3 == 1000) {
                throw new BuildException("Can't find available temporary filename to which to rename old file.");
            }
            try {
                if (!this.zipFile.renameTo(var1_1)) {
                    throw new BuildException("Unable to rename old file to temporary file");
                }
            }
            catch (SecurityException var4_5) {
                throw new BuildException("Not allowed to rename old file to temporary file");
            }
        }
        var3_4 = new Vector<DirectoryScanner>();
        if (this.baseDir != null) {
            var3_4.addElement(this.getDirectoryScanner(this.baseDir));
        }
        var4_6 = 0;
        while (var4_6 < this.filesets.size()) {
            var5_7 = (FileSet)this.filesets.elementAt(var4_6);
            var3_4.addElement(var5_7.getDirectoryScanner(this.project));
            ++var4_6;
        }
        var5_8 = var3_4.size();
        var6_9 = new FileScanner[var5_8];
        var3_4.copyInto(var6_9);
        if (this.isUpToDate((FileScanner[])var6_9, this.zipFile)) {
            return;
        }
        var7_10 = var2_2 != false ? "Updating " : "Building ";
        this.log(var7_10 + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        var8_11 = false;
        try {
            try {
                var9_12 = new ZipOutputStream(new FileOutputStream(this.zipFile));
                var9_12.setEncoding(this.encoding);
                try {
                    if (this.doCompress) {
                        var9_12.setMethod(8);
                    } else {
                        var9_12.setMethod(0);
                    }
                    this.initZipOutputStream(var9_12);
                    if (this.baseDir != null) {
                        this.addFiles(this.getDirectoryScanner(this.baseDir), var9_12, "", "");
                    }
                    this.addFiles(this.filesets, var9_12);
                    if (var2_2) {
                        this.addingNewFiles = false;
                        var10_14 = new ZipFileSet();
                        var10_14.setSrc(var1_1);
                        var11_16 = new StringBuffer();
                        var12_17 = 0;
                        while (var12_17 < this.addedFiles.size()) {
                            if (var12_17 != 0) {
                                var11_16.append(",");
                            }
                            var11_16.append((String)this.addedFiles.elementAt(var12_17));
                            ++var12_17;
                        }
                        var10_14.setExcludes(var11_16.toString());
                        var13_18 = new Vector<ZipFileSet>();
                        var13_18.addElement(var10_14);
                        this.addFiles(var13_18, var9_12);
                    }
                    this.finalizeZipOutputStream(var9_12);
                    var8_11 = true;
                    var15_19 = null;
                }
                catch (Throwable var14_23) {
                    block30: {
                        var15_20 = null;
                        try {
                            if (var9_12 != null) {
                                var9_12.close();
                            }
                        }
                        catch (IOException var16_22) {
                            if (!var8_11) break block30;
                            throw var16_22;
                        }
                    }
                    throw var14_23;
                }
                try {
                    if (var9_12 == null) ** GOTO lbl95
                    var9_12.close();
                }
                catch (IOException var16_21) {
                    if (!var8_11) ** GOTO lbl95
                    throw var16_21;
                }
lbl95:
                // 3 sources

                var18_24 = null;
                this.cleanUp();
            }
            catch (IOException var9_13) {
                var10_15 = "Problem creating " + this.archiveType + ": " + var9_13.getMessage();
                if (!this.zipFile.delete()) {
                    var10_15 = var10_15 + " (and the archive is probably corrupt but I could not delete it)";
                }
                if (var2_2 && !var1_1.renameTo(this.zipFile)) {
                    var10_15 = var10_15 + " (and I couldn't rename the temporary file " + var1_1.getName() + " back)";
                }
                throw new BuildException(var10_15, var9_13, this.location);
            }
        }
        catch (Throwable var17_26) {
            var18_25 = null;
            this.cleanUp();
            throw var17_26;
        }
        if (var8_11 && var2_2 && !var1_1.delete()) {
            this.log("Warning: unable to delete temporary file " + var1_1.getName(), 1);
        }
    }

    protected boolean isAddingNewFiles() {
        return this.addingNewFiles;
    }

    protected void addFiles(FileScanner fileScanner, ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        Object object;
        if (string.length() > 0 && string2.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes may not be set on the same fileset.");
        }
        File file = fileScanner.getBasedir();
        String[] stringArray = fileScanner.getIncludedDirectories();
        if (stringArray.length > 0 && string2.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!"".equals(stringArray[n])) {
                object = stringArray[n].replace(File.separatorChar, '/');
                if (!((String)object).endsWith("/")) {
                    object = (String)object + "/";
                }
                this.addParentDirs(file, (String)object, zipOutputStream, string);
            }
            ++n;
        }
        object = fileScanner.getIncludedFiles();
        if (((String[])object).length > 1 && string2.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        int n2 = 0;
        while (n2 < ((String[])object).length) {
            File file2 = new File(file, (String)object[n2]);
            if (string2.length() > 0) {
                this.addParentDirs(null, string2, zipOutputStream, "");
                this.zipFile(file2, zipOutputStream, string2);
            } else {
                String string3 = ((String)object[n2]).replace(File.separatorChar, '/');
                this.addParentDirs(file, string3, zipOutputStream, string);
                this.zipFile(file2, zipOutputStream, string + string3);
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addZipEntries(ZipFileSet zipFileSet, DirectoryScanner directoryScanner, ZipOutputStream zipOutputStream, String string) throws IOException {
        ZipScanner zipScanner = (ZipScanner)directoryScanner;
        File file = zipFileSet.getSrc();
        ZipInputStream zipInputStream = null;
        try {
            java.util.zip.ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipEntry zipEntry2 = new ZipEntry(zipEntry);
                String string2 = zipEntry2.getName();
                if (!zipScanner.match(string2)) continue;
                this.addParentDirs(null, string2, zipOutputStream, string);
                if (zipEntry2.isDirectory()) continue;
                this.zipFile(zipInputStream, zipOutputStream, string + string2, zipEntry2.getTime());
            }
            Object var12_11 = null;
            if (zipInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (zipInputStream == null) throw throwable;
            zipInputStream.close();
            throw throwable;
        }
        zipInputStream.close();
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    protected void finalizeZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    protected boolean createEmptyZip(File file) {
        this.log("Note: creating empty " + this.archiveType + " archive " + file, 2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                byte[] byArray = new byte[22];
                byArray[0] = 80;
                byArray[1] = 75;
                byArray[2] = 5;
                byArray[3] = 6;
                ((OutputStream)fileOutputStream).write(byArray);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            ((OutputStream)fileOutputStream).close();
            {
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not create empty ZIP archive", iOException, this.location);
        }
        return true;
    }

    protected boolean isUpToDate(FileScanner[] fileScannerArray, File file) throws BuildException {
        String[][] stringArray = Zip.grabFileNames(fileScannerArray);
        File[] fileArray = Zip.grabFiles(fileScannerArray, stringArray);
        if (fileArray.length == 0) {
            if (this.emptyBehavior.equals("skip")) {
                this.log("Warning: skipping " + this.archiveType + " archive " + file + " because no files were included.", 1);
                return true;
            }
            if (this.emptyBehavior.equals("fail")) {
                throw new BuildException("Cannot create " + this.archiveType + " archive " + file + ": no files were included.", this.location);
            }
            return this.createEmptyZip(file);
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].equals(file)) {
                throw new BuildException("A zip file cannot include itself", this.location);
            }
            ++n;
        }
        if (!file.exists()) {
            return false;
        }
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        MergingMapper mergingMapper = new MergingMapper();
        mergingMapper.setTo(file.getAbsolutePath());
        int n2 = 0;
        while (n2 < fileScannerArray.length) {
            if (sourceFileScanner.restrict(stringArray[n2], fileScannerArray[n2].getBasedir(), null, mergingMapper).length > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected static File[] grabFiles(FileScanner[] fileScannerArray) {
        return Zip.grabFiles(fileScannerArray, Zip.grabFileNames(fileScannerArray));
    }

    protected static File[] grabFiles(FileScanner[] fileScannerArray, String[][] stringArray) {
        Object[] objectArray;
        Vector<File> vector = new Vector<File>();
        int n = 0;
        while (n < stringArray.length) {
            objectArray = fileScannerArray[n].getBasedir();
            int n2 = 0;
            while (n2 < stringArray[n].length) {
                vector.addElement(new File((File)objectArray, stringArray[n][n2]));
                ++n2;
            }
            ++n;
        }
        objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static String[][] grabFileNames(FileScanner[] fileScannerArray) {
        String[][] stringArray = new String[fileScannerArray.length][];
        int n = 0;
        while (n < fileScannerArray.length) {
            String[] stringArray2 = fileScannerArray[n].getIncludedFiles();
            String[] stringArray3 = fileScannerArray[n].getIncludedDirectories();
            stringArray[n] = new String[stringArray2.length + stringArray3.length];
            System.arraycopy(stringArray2, 0, stringArray[n], 0, stringArray2.length);
            System.arraycopy(stringArray3, 0, stringArray[n], stringArray2.length, stringArray3.length);
            ++n;
        }
        return stringArray;
    }

    protected void zipDir(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (this.addedDirs.get(string) != null) {
            return;
        }
        this.addedDirs.put(string, string);
        ZipEntry zipEntry = new ZipEntry(string);
        if (file != null && file.exists()) {
            zipEntry.setTime(file.lastModified());
        } else {
            zipEntry.setTime(System.currentTimeMillis());
        }
        zipEntry.setSize(0L);
        zipEntry.setMethod(0);
        zipEntry.setCrc(emptyCrc);
        zipEntry.setExternalAttributes(1107099664L);
        zipOutputStream.putNextEntry(zipEntry);
    }

    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(l);
        if (!this.doCompress) {
            Object object;
            long l2 = 0L;
            CRC32 cRC32 = new CRC32();
            if (!inputStream.markSupported()) {
                object = new ByteArrayOutputStream();
                byte[] byArray = new byte[8192];
                int n = 0;
                do {
                    l2 += (long)n;
                    cRC32.update(byArray, 0, n);
                    ((ByteArrayOutputStream)object).write(byArray, 0, n);
                } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
                inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            } else {
                inputStream.mark(Integer.MAX_VALUE);
                object = new byte[8192];
                int n = 0;
                do {
                    l2 += (long)n;
                    cRC32.update((byte[])object, 0, n);
                } while ((n = inputStream.read((byte[])object, 0, ((Object)object).length)) != -1);
                inputStream.reset();
            }
            zipEntry.setSize(l2);
            zipEntry.setCrc(cRC32.getValue());
        }
        zipOutputStream.putNextEntry(zipEntry);
        byte[] byArray = new byte[8192];
        int n = 0;
        do {
            if (n == 0) continue;
            zipOutputStream.write(byArray, 0, n);
        } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
        this.addedFiles.addElement(string);
    }

    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (file.equals(this.zipFile)) {
            throw new BuildException("A zip file cannot include itself", this.location);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.zipFile(fileInputStream, zipOutputStream, string, file.lastModified());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    protected void addParentDirs(File file, String string, ZipOutputStream zipOutputStream, String string2) throws IOException {
        if (!this.doFilesonly) {
            String string3;
            Stack<String> stack = new Stack<String>();
            int n = string.length();
            while ((n = string.lastIndexOf(47, n - 1)) != -1) {
                string3 = string.substring(0, n + 1);
                if (this.addedDirs.get(string2 + string3) != null) break;
                stack.push(string3);
            }
            while (!stack.isEmpty()) {
                string3 = (String)stack.pop();
                File file2 = null;
                file2 = file != null ? new File(file, string3) : new File(string3);
                this.zipDir(file2, zipOutputStream, string2 + string3);
            }
        }
    }

    protected void addFiles(Vector vector, ZipOutputStream zipOutputStream) throws IOException {
        int n = 0;
        while (n < vector.size()) {
            FileSet fileSet = (FileSet)vector.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            String string = "";
            String string2 = "";
            if (fileSet instanceof ZipFileSet) {
                ZipFileSet zipFileSet = (ZipFileSet)fileSet;
                string = zipFileSet.getPrefix();
                string2 = zipFileSet.getFullpath();
            }
            if (string.length() > 0 && !string.endsWith("/") && !string.endsWith("\\")) {
                string = string + "/";
            }
            if (string.length() > 0) {
                this.addParentDirs(null, string, zipOutputStream, "");
                this.zipDir(null, zipOutputStream, string);
            } else if (string2.length() > 0) {
                this.addParentDirs(null, string2, zipOutputStream, "");
            }
            if (fileSet instanceof ZipFileSet && ((ZipFileSet)fileSet).getSrc() != null) {
                this.addZipEntries((ZipFileSet)fileSet, directoryScanner, zipOutputStream, string);
            } else {
                this.addFiles(directoryScanner, zipOutputStream, string, string2);
            }
            ++n;
        }
    }

    protected void cleanUp() {
        this.addedDirs = new Hashtable();
        this.addedFiles = new Vector();
    }

    public static class WhenEmpty
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"fail", "skip", "create"};
        }
    }
}

