/**********************************************************************/
/* MISC.C : Fonctions sans lien particulier avec le reste de JE	      */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#include <ctype.h>
#include "jered.h"
#include "messages.h"

extern int escape_mode;
extern int insert_mode;
extern char helpbar[256];
extern char eschelpbar[256];
extern int resizewin;

/**********************************************************************/
void erreur(char *fmt, char *mess)
/* PURPOSE OF FUNCTION:
This function displays an alert box with eventually a string parameter
used for example for the filename to be displayed. It is called when
an error occurs somewhere.
 ..................................*/
{
	char tmp[80];

	if (mess != NULL)
		sprintf(tmp, fmt, mess);
	else
		strcpy(tmp, fmt);
	alerte(1, tmp, message[MSG_OK]);
}
/**********************************************************************/
int askquestion(void)
/* PURPOSE OF FUNCTION:
This function is used during the Find & Replace action to ask the user
if he wants to Continue/Replace/replace All/Stop the search. It first
saves was is on the bottom line of the screen, then displays the
question and reads the keyboard. In we are in FRENCH, the if we
press 'T' (Tout <==> All) we do as if the user pressed 'A' to
simplify tests. It restores what was on the bottom line of the
screen, then it returns the key pressed which must be one of C/R/A/S.
 ....................................*/
{
	chtype buffer[256];
	int touche;
	int ok;

	inputmode = DIALOGMODE;

	get_txt(0, (JEREDLINES - 1), (JEREDCOLS - 1), (JEREDLINES - 1), buffer);
	put_statligne(0, (JEREDLINES - 1), message[MSG_QUESTION], couleur[COULEUR_AIDE]);
	refresh();
	do
	{
		ok = 0;
		touche = fread_key();
		touche = toupper(touche);

		/* now we must translate keys in the current language */
		/* to the same keys in English to simplify tests */
		switch (language)
		{
			case FRENCH:
				/* nothing to be done for: Continue <=> Continue */
				/*			   Remplace <=> Replace */
				/*			   Stop <=> Stop */
				if ((touche == 'C') || (touche == 'R') || (touche == 'T') || (touche == 'S'))
					ok = 1;

				if (touche == 'T')
					touche = 'A';	/* Tout <=> All */
				break;

			case SPANISH:
				/* nothing to be done for: Continue <=> Continua */
				/*			   Remplace <=> Reemplaza */
				if ((touche == 'C') || (touche == 'R') || (touche == 'T') || (touche == 'P'))
					ok = 1;

				if (touche == 'T')
					touche = 'A';	/* Todos <=> All */
				if (touche == 'P')
					touche = 'S';	/* Parar <=> Stop */
				break;

			case FINNISH:
				/* nothing to be done for: kAikki <=> All */
				if ((touche == 'J') || (touche == 'K') || (touche == 'A') || (touche == 'L'))
					ok = 1;

				if (touche == 'J')
					touche = 'C';	/* Jatka <=> Continue */
				else if (touche == 'K')
					touche = 'R';	/* Korvaa <=> Replace */
				else if (touche == 'L')
					touche = 'S';	/* Lopeta <=> Stop */
				break;

			case RUSSIAN:
				if ((touche == '') || (touche == '') || (touche == '') || (touche == ''))
					ok = 1;

				if (touche == '')
					touche = 'C';	/*  <=> Skip (better in Russian than Continue) */
				if (touche == '')
					touche = 'R';	/*  <=> Replace */
				if (touche == '')
					touche = 'A';	/*  <=> All */
				if (touche == '')
					touche = 'S';	/*  <=> Stop */
				break;

			case GERMAN:
				/* to be modified, don't forget the break; */
			case ENGLISH:
				/* nothing to be done !!! */
			default:	/* Continue	 Replace	     All		Stop */
				if ((touche == 'C') || (touche == 'R') || (touche == 'A') || (touche == 'S'))
					ok = 1;

				break;
		}
	}
	while (! ok) ;
	put_txt(0, (JEREDLINES - 1), (JEREDCOLS - 1), (JEREDLINES - 1), buffer);

	inputmode = NORMALMODE;
	if (resizewin)
		restart_screen_again();

	return(touche);
}
/**********************************************************************/
chtype *sauve_ecran(void)
/* PURPOSE OF FUNCTION:
This function is called when you execute a shell out or an external
command. This function allocates memory to save in a buffer all what
is on the screen. Then it saves the screen in this buffer, clears
the screen, calls functions to save current curses mode and switch
to normal (shell) mode. It returns a pointer to the allocated memory
or NULL if no memory is available.
 ....................................*/
{
	chtype *buffer;

	buffer = (chtype *)malloc(JEREDLINES * JEREDCOLS * sizeof(chtype));
	if (buffer != NULL)
	{
		get_txt(0, 0, (JEREDCOLS - 1), (JEREDLINES - 1), buffer);

		clr_scr();

		def_prog_mode();
		reset_shell_mode();
	}
	return(buffer);
}
/**********************************************************************/
void restaure_ecran(chtype *buffer, int waitakey)
/* PURPOSE OF FUNCTION:
This function is called when you exit from a shell out or an
external command. This function reswitch to curses mode. If the
parameter 'waitakey' is set to ATTENDSTOUCHE (WAITAKEY), then it
displays a message on the bottom line to ask the user to press a
key and waits for any key to be pressed. Then it clears the screen,
restores what was on the screen before the shell out and frees the
memory allocated in sauve_ecran().
 .................................*/
{
	inputmode = DIALOGMODE;

	reset_prog_mode();

	if (waitakey == ATTENDSTOUCHE)
	{
		put_statligne(0, (JEREDLINES - 1), message[MSG_PRESS_ANYKEY], couleur[COULEUR_AIDE]);
		fread_key();
	}

	clr_scr();

	put_txt(0, 0, (JEREDCOLS - 1), (JEREDLINES - 1), buffer);

	refresh();

	free(buffer);

	inputmode = NORMALMODE;
}
/**********************************************************************/
void affiche_status_line(FICHIER *fichier, int colonne)
/* PURPOSE OF FUNCTION:
This function computes and displays the status line at the top of
the screen, according to the FICHIER structure pointed to by the
arg 'fichier' and the cursor's real column (between 1 and 2000)
in the arg 'colonne'. It calls beautify_filename() to ensure that
the filename will fit on the screen. It also displays if we are
recording or playing a macro.
 ....................................*/
{
	char *chinsertion;	/* pour libelle Insertion/Remplacement */
	char status_line[256];	/* pour ligne d'etat */
	char mac;		/* pour etat de la macro */

	chinsertion = ((insert_mode == INSERT) ? message[MSG_INSERT] : message[MSG_REPLACE]);
	if (macro == RECORDING)
		mac = 'R';
	else if (macro == PLAYING)
		mac = 'P';
	else
		mac = ' ';
	sprintf(status_line, message[MSG_STATUS], colonne, fichier->numcourante, fichier->nblignes, mac, chinsertion);

	beautify_filename(status_line, fichier->filename);

	put_statligne(0, 0, status_line, couleur[COULEUR_STATUS]);
}
/**********************************************************************/
void affiche_help_line(void)
/* PURPOSE OF FUNCTION:
This function displays the help bar according to if we are in
normal mode or in escape mode. The help bar is at the bottom of
the screen.
 ......................................*/
{
	if (escape_mode)
		put_helpline(0, (JEREDLINES - 1), eschelpbar, couleur[COULEUR_AIDE]);
	else
		put_helpline(0, (JEREDLINES - 1), helpbar, couleur[COULEUR_AIDE]);
}
/**********************************************************************/
void inverse_insert_mode(void)
/* PURPOSE OF FUNCTION:
This functions toggle between insert and replace mode, and tries to
show a big cursor in insert mode and a small cursor in replace mode.
This is currently not supported with my ncurses 1.9.9e. The problem
is located in the termcap/terminfo terminal description.
 ..........................................*/
{
	if (insert_mode == INSERT)
	{
		insert_mode = REPLACE;
		allume_curseur(2);
	}
	else
	{
		insert_mode = INSERT;
		allume_curseur(1);
	}
}
/**********************************************************************/
int confirmation(char *questiontoask)
/* PURPOSE OF FUNCTION:
This function is used to ask for a confirmation YES/NO or OUI/NON
in an alert box. The message of the alert box is passed in the
'question' arg. This function returns 1 if the answer was YES/OUI
and 0 otherwise (if the user chose NO/NON or if he pressed ESCAPE).
 .......................................*/
{
	char *yesno;

	yesno = message[MSG_YESNO];
	if (alerte(1, questiontoask, yesno) == 1)
		return(1);
	else
		return(0);
}
/**********************************************************************/
void beautify_filename(char *string, char *filename)
/* PURPOSE OF FUNCTION:
This function is used to ensure that a 'filename' concatenated
to the arg 'string' will allow 'string' to fit on the screen.
If it is not the case, then we cut the beginning of the filename
and we add '(...)' at its beginning to show that the displayed
filename is longer in reality.
 ......................................*/
{
	int lgl;	/* string length */
	int lgf;	/* filename length */

	/* cut the filename to feet on the screen */
	lgl = strlen(string);
	lgf = strlen(filename);
	if ((lgl + lgf) >= (JEREDCOLS - 5))   /* see below for the 5 explanation */
	{
		strcat(string, "(...)");   /* 5 more characters */
		strcat(string, filename + (lgl + lgf + 5 - JEREDCOLS));
	}
	else
		strcat(string, filename);
}
/**********************************************************************/
