package jfractionlab.worksheets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

import javax.swing.JOptionPane;

import jfractionlab.JFractionLab;
import jfractionlab.jflOptionDialogs.InfoDialog;

abstract class WorkSheetGenerator {

	protected String strhead="";
	protected ArrayList<String> al_excercisesText;
	protected ArrayList<String> al_solutionsText;
	protected ArrayList<String> al_solutionLine;
	protected static final int nb_of_excercises = 36;
	protected static final int solutions_per_line = 18; //solutions per line
	
	public WorkSheetGenerator(String title){
		al_excercisesText = new ArrayList<String>();
		al_solutionsText = new ArrayList<String>();
		strhead= 
			"\\documentclass[12pt,ngerman,a4]{scrartcl}\n"+
			"\\usepackage[T1]{fontenc}\n"+
			"\\usepackage{ucs}\n"+
			"\\usepackage[utf8x]{inputenc}\n"+
			"\\usepackage{ngerman}\n"+
			"\\usepackage[ngerman]{babel}\n"+
			"\\usepackage{cancel}\n"+
			"\\setlength{\\parindent}{0pt}\n"+
			"\\pagestyle{empty}\n"+
			"\\begin{document}\n"+
			title+"\\\\\n"+
			"\\\\\n"+
			"\\begin{tabular}{p{8cm} p{8cm}}\n"+
			lang.Messages.getString("name")+
				" & "+
				lang.Messages.getString("date")+
				"\\\\\n"+
			"\\end{tabular}\n"+
			"\\renewcommand{\\arraystretch}{2}\n"+
			"\\begin{tabular}{|r|p{7cm}|r|p{7cm}|}\n"+
			"\\hline\n";
	}

	abstract protected void mkExcercises(int nb, int max);
	abstract protected String writeOneLine(boolean isExcercise, int nb);

//	abstract protected void generateText();
	protected void generateText() {
	writeTxTLists("both",strhead);
	//----------------------------
	for (int i = 0; i < nb_of_excercises; i++){
		writeTxTLists("excercise", writeOneLine(true, i));
		writeTxTLists("solution", writeOneLine(false, i));
		writeTxTLists("both", "\\hline");
		i++;
	}//for
	//----------------------------
	writeTxTLists("both","\\end{tabular}");
	//----------------------------
	String cc="";
	for(int i = 0; i< solutions_per_line; i++){
		cc += "c";
	}
	writeTxTLists("excercise", "\\begin{center}");
	writeTxTLists("excercise", "\\renewcommand{\\arraystretch}{2}");
	writeTxTLists("excercise", "\\begin{tabular}{"+cc+"}");
	writeTxTLists("excercise", writeSolutionLine(al_solutionLine));
	writeTxTLists("excercise", "\\end{tabular}");
	writeTxTLists("excercise", "\\end{center}");
	//----------------------------
	writeTxTLists("both", "\\end{document}");
}
	
	protected String writeSolutionLine(ArrayList<String> al) {
		String strReturn = "";
		int r;
		int i = 0;
		do{
			r = JFractionLab.ran.nextInt(al.size());
			strReturn += al.get(r);
			i++;
			if(i == solutions_per_line){
				strReturn += "\\\\";
				i = 0;
			}else{
				strReturn += ", ";
			}
			al.remove(r);
		}while(al.size()> 0);
		return strReturn;
	}
	
	protected void writeTxTLists(String target, String txt){
		if(target.equals("both")){
			al_excercisesText.add(txt);
			al_solutionsText.add(txt);
		}else if(target.equals("excercise")){
			al_excercisesText.add(txt);
		}else if(target.equals("solution")){
			al_solutionsText.add(txt);
		}else{
			throw new IllegalArgumentException("wrong argument");
		}
	}	
	
	protected void writeFiles(File file){
		writeFile(
				new File(file.getAbsolutePath() + "_" + lang.Messages.getString("excercises.tex")),
				al_excercisesText
		);
		writeFile(
				new File(file.getAbsolutePath() + "_" + lang.Messages.getString("solutions.tex")),
				al_solutionsText
		);
	}
	
	protected void writeFile(File fl, ArrayList<String> al){
		boolean isAlreadyShown = false;
		try {
			BufferedWriter bw = new BufferedWriter(
				new OutputStreamWriter(
					new FileOutputStream(fl),
					"UTF-8"
				)//OutputStreamWriter
			);//BufferedWriter
			for (int i = 0; i < al.size(); i++){
				bw.write(al.get(i));
				bw.newLine();
			}
			bw.close();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			if(isAlreadyShown){
				new InfoDialog(lang.Messages.getString("title_pdfproblem"),
					"WorkSheetGenerator"+"<br>"+
					"UnsupportedEncodingException"
				);
			}
			isAlreadyShown = true;
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			if(isAlreadyShown){
				new InfoDialog(lang.Messages.getString("title_pdfproblem"),
						"WorkSheetGenerator"+
						"<br><br>"+
						lang.Messages.getString("files_can_not_be_saved")+
						"<br>"+
						lang.Messages.getString("file_not_found_exception")+
						"<br>"+
						lang.Messages.getString("correct_the_filename")
				);
			}
			isAlreadyShown = true;
		} catch (IOException e) {
			e.printStackTrace();
			if(isAlreadyShown){
				new InfoDialog(lang.Messages.getString("title_pdfproblem"),
								"WorkSheetGenerator"+"<br>"+
								"IOException"
				);
			}
			isAlreadyShown = true;
		}
		String path = "";
		boolean isOK = false;
		try {
			String strpath = "";
			strpath = fl.getCanonicalPath();
			int uu = strpath.lastIndexOf(fl.getName());
			path = strpath.substring(0, uu);
			isOK = true;
		} catch (IOException e) {
			e.printStackTrace();
			new InfoDialog(lang.Messages.getString("title_pdfproblem"),
					lang.Messages.getString(
							"WorkSheetGenerator"+"<br>"+
							"IOException, getCanonicalPath"
					)
			);
		}
		if(isOK){
			try {
				//FIXME if else ist nur provisorisch fuer windows tests
				if(System.getProperty("os.name").contains("nux")){
					Runtime.getRuntime().exec("pdflatex -output-directory "+path+" "+fl);
				}else{
	JOptionPane.showMessageDialog(null,
			"C:\\Programme\\MiKTeX 2.8\\miktex\\bin\\pdflatex.exe\n -output-directory "
			+path+"\n "+fl.toString()
	);
					Runtime.getRuntime().exec(
						"C:\\Programme\\MiKTeX 2.8\\miktex\\bin\\pdflatex.exe -output-directory "+path+" "+fl);
				}
			} catch (IOException e) {
				e.printStackTrace();
				new InfoDialog(
						lang.Messages.getString("title_pdfproblem"),
						lang.Messages.getString("pdflatex_is_not_installed")+"<br><br>"+
						lang.Messages.getString("worksheets_only_in_tex")+"<br><br>"+
						lang.Messages.getString("what_is_tex")+"<br>"+
						lang.Messages.getString("jfl_and_tex")+"<br>"+
						lang.Messages.getString("why_pdflatex")+"<br><br>"+
						lang.Messages.getString("install_linux_pdflatex")+"<br>"+
						lang.Messages.getString("install_mac_pdflatex")+"<br>"+
						lang.Messages.getString("install_win_pdflatex")+"<br><br>"+
						lang.Messages.getString("pdflatex_manually")
				);
			}
		}
	}
	

}
