/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
*/
#ifndef _H_JFS_DEBUG
#define _H_JFS_DEBUG

/*
 *	jfs_debug.h
 *
 * global debug message, data structure/macro definitions
 * under control of _JFS_DEBUG, _JFS_STATISTICS;
 *
 * note: for individual modulei debug control, use _JFS_DEBUG_module;
 */

void dump_mem(char *label, void *data, int length);

/*
 *	assert with traditional printf/panic
 */

#define assert(p) {\
if (!(p))\
	{\
    printf("Assert failure! \n");\
		printf("[%s #%d]\n",__FILE__,__LINE__);\
		abort();\
	}\
}

/*
 *	chatterbox control
 */
/* temporary until cleanup */
#define	NOISE(button,prspec)

/*
 *	debug ON
 *	--------
 */
#ifdef _JFS_DEBUG
#define ASSERT(p) assert(p)

/* information message: e.g., configuration, major event */
extern int jfsFYI;
#define jFYI(button,prspec)\
{ if (button && jfsFYI) printk prspec; }

/*
 *	chatterbox control
 */
/* debug event message: */
#define jEVENT(button,prspec)\
{ if (button) printk prspec; }

/* alert warning message: e.g., critical event */
extern int jfsALERT;
#define jALERT(button, prspec)\
{ if (button && jfsALERT) printk prspec; }

/* error event message: e.g., i/o error */
extern int jfsERROR;
#define jERROR(button, prspec)\
{ if (button && jfsERROR) { printk prspec; if (button > 1) BUG(); } }

/* if dial is set above volume level of given message, print it */
#define jNOISESET(dial, level)	int dial = (level);
#define jNOISEGET(dial)		extern dial;
#define jNOISE(dial,level,prspec)\
{ if ((dial) >= (level)) printk prspec; }

/* invoke sanity check function */
#define jSANITY(funct, arg)\
{ funct(arg); }

/*
 *	debug OFF
 *	---------
 */
#else				/* _JFS_DEBUG */
#define ASSERT(p)
#define jEVENT(button,prspec)
#define jERROR(button,prspec)
#define jALERT(button,prspec)
#define jFYI(button,prspec)
#define jNOISESET(dial, level)
#define jNOISEGET(dial)
#define jNOISE(dial,level,prspec)
#define jSANITY(funct, arg)
#endif				/* _JFS_DEBUG */

/*
 *	statistics
 *	----------
 */
#ifdef	_JFS_STATISTICS
#define	INCREMENT(x)	((x)++)
#define	DECREMENT(x)	((x)--)
#define	HIGHWATERMARK(x,y)	x = MAX((x), (y))
#else
#define	INCREMENT(x)
#define	DECREMENT(x)
#define	HIGHWATERMARK(x,y)
#endif				/* _JFS_STATISTICS */

#endif				/* _H_JFS_DEBUG */
