/*
    Copyright (C) 2008 Fons Adriaensen <fons@kokkinizita.net>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __METERWIN_H
#define	__METERWIN_H


#include <math.h>
#include <clxclient.h>


class Meterwin : public X_window
{
public:

    enum { MVUM, SVUM, MPPM, SPPM, MPPM2, SPPM2, NTYPES };

    Meterwin (X_window *parent, int xpos, int ypos, int type, XftColor *bgnd, Pixmap pixm);
    ~Meterwin (void);
    Meterwin (const Meterwin&);
    Meterwin& operator=(const Meterwin&);

    int xs (void) { return _xs; }
    int ys (void) { return _ys; }

    void set_val (float v1, float v2);
    void set_col (XftColor *c1, XftColor *c2) { _col1 = c1; _col2 = c2; }
    void update (void);

private:

    void handle_event (XEvent *);
    void expose (XExposeEvent *E);
    void redraw (void);
    void needle (float val, XftColor *col);

    float vum_map (float v)
    {
//	return 0.761896f * v - 0.0762f;
	return 0.707946f * v;
    }

    float ppm_map (float v)
    {
	v *= 1.585f;
        if (v < 0.1f) return v * 0.855f;
	else return 0.3f * log (v) + 0.77633f;
    }

    int        _type;
    XftColor  *_bgnd;
    int        _xs;
    int        _ys;
    int        _xc;
    int        _yc;
    int        _r1;
    int        _r2;
    XftColor  *_col1;
    XftColor  *_col2;
    float      _val1;
    float      _val2;
};


#endif
