#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <jni.h>
#include <jvmpi.h>
#include <jmp-config.h>
#include <jmp.h>
#include <errno.h>
#include <heap_dump.h>
#include <ui.h>

static int string_file_counter = -1;
static char filename[128];

FILE* get_string_dump_file () {
    FILE* f;
    snprintf (filename, 128, "jmp_string_dump-%d.txt", ++string_file_counter);
    f = fopen (filename, "w");
    return f;
}

char* get_current_dump_file () {
    return filename;
}

int write_string (FILE* f, char* text, int count, int used) {
    return fprintf (f, "'%d'\t'%d'\t'%s'\n", used, count, text);    
}

void dump_string (obj* o, FILE* f) {
    down_link* dl;
    get_instance_info (o);
    dl = get_last_down_link ();
    while (dl != NULL) {
	long items_written;
	int err = 0;
	char* converted_text;

	switch (dl->type) {
	case JVMPI_GC_PRIM_ARRAY_DUMP:
	    converted_text = jmp_utf16_to_utf8 (dl->value.txt, dl->pos, &items_written, &err); 
	    if (err != 0) {
		fprintf (stderr, "Unable to convert text: %s\n", strerror (err));	
		break;
	    }
	    write_string (f, converted_text, 1, dl->pos * 2);
	    free (converted_text);
	    break;
	default:
	    fprintf (stderr, "Odd type when dumping string: %d\n", dl->type);
	}
	dl = dl->next;	
    }
    free_last_down_link ();	
}

void dump_strings () {
    FILE* f;
    f = get_string_dump_file ();
    for_each_string ((string_callback)dump_string, f);
    fclose (f);
}
