#ifndef JMPTIME_H__
#define JMPTIME_H__

#ifdef HAVE_SYS_TIME_H
 #include <sys/time.h>
#endif
#include <jni.h>
#include <jvmpi.h>

/** Returns a jlong with the current time in nanoseconds.
 *  If gettimeofday is available it is used, otherwise we 
 *  use jvmpi->GetCurrentThreadCpuTime, which is not the same 
 *  thing but similar...
 * 
 */
jlong get_absolute_time (JVMPI_Interface* jvmpi);

extern jlong (*get_thread_time) (JVMPI_Interface* jvmpi);

/**
 * Final calibration of the timinig functions. Set absolute time to true if
 * absolute times are preferred against cpu times.
 */
void jmptime_init (int absolute_time, const char* vm_version,
		   const char* vm_vendor, const char* vm_name);

/** Split the time value into second and nanons 
 * @param td the current time
 * @param jsec a pointer to where the seconds will be stored
 * @param jnsec a pointer to where the nano seconds will be stored
 */
void jmptime_set_time_values (jlong td, jlong* jsec, jlong* jnsec);

#endif /* JMPTIME_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
