#ifndef UI_NONE_H__
#define UI_NONE_H__

extern int exit_on_jvm_shutdown;

/** do ui clean. */
void end_ui (void);

/** do any special ui initialization. */
extern void init_ui (void);

/** The thread used to run gtk-main. 
 */
extern void gtkthread (void* data);

/** Tell the ui system to shutdown and wait for it to do so. */
extern int quit_ui (void);

/** Tell the ui system it can startup. */
extern void start_ui (void);

/** Tell the ui the jvm has shutdown */
extern void notify_profile_window_begin_ui (void);
extern void notify_profile_window_end_ui (void);
extern void notify_profile_window_close_ui (void);
extern void notify_jvm_shutdown_ui (void);
extern void notify_update_full_try_ui (void);

/** Tell the ui system it should shutdown. */
extern void stop_ui (void);

/** Update the statistics. */
extern void updateUI (hashtab* cls, hashtab* methods);

/** Return the id of the dump file. */
extern int dump_data (char* dumpfile, hashtab* cls, hashtab* methods, hashtab* threads);

/** Set the dump timer... */
extern void set_dump_timer (int dumptimer);

/** Get the current dump timer. */
extern int get_dump_timer (void);

/** Set the status text on the main status bar, we're threadsafe. */
extern void set_status (const char* text);

/** Check if we have any ui-handling to do. */
extern int events_pending (void);

/** Update the ui-toolkit (gtk_main_iteration ()) */
extern int ui_iteration (void);

/** Are we initialising or already running */
extern int ui_gtk_state (void);

/** Show deadlock */
extern void show_deadlock (visited_threads* vt);

#endif /* UI_NONE_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
