
/*
 * child.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PLAYER_CHILD_H
#define PLAYER_CHILD_H

#include <ncurses.h>

#include "typedefs.h"

bool child_create (const char *command,char *arguments[]);	 /* Create child process */
bool child_invoke (chtype hotkey);				 /* Switch to child process */
void child_destroy ();							 /* Destroy child process */
bool child_alive ();							 /* Check if child is still alive */
void child_pause ();							 /* Send SIGSTOP to child */
void child_resume ();							 /* Send SIGCONT to child */
void child_skip ();								 /* Send SIGINT to child */

/* NOTE: This is necessary because some programs tend to stop (e.g. mpg123) if */
/* we don't keep reading from the terminal */
void child_flush_start ();						 /* Start child flush handler */
void child_flush_stop ();						 /* Stop child flush handler */

#endif
