
/*
 * config.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CONFIG_CONFIG_H
#define CONFIG_CONFIG_H

typedef struct ConfigRec
{
   struct ConfigRec *next;
   char *idname;				/* Identifier name */
   int type;					/* Type of identifier. */
   int value;					/* Value of identifier if type is CFG_TYPE_INTEGER */
   bool state;					/* State of identifier if type is CFG_TYPE_BOOLEAN */
   char *txt;					/* Identifier string if type is CFG_TYPE_STRING */
} ConfigList;

class Config
{
 public:
   /* Initialize datastructures */
   Config ();
   /* Cleanup datastructures */
   ~Config ();
   /* Parse configuration file */
   int Parse (const char *filename);
   /* Create new configuration file */
   int Create (const char *filename,const char *format, ...);
   /* Save current settings */
   int Save (const char *filename);
   /* Add an entry (integer type) */
   void AddInteger (const char *idname,int value);
   /* Add an entry (boolean type) */
   void AddBoolean (const char *idname,bool state);
   /* Add an entry (string type) */
   void AddString (const char *idname,const char *txt);
   /* Remove an entry */
   void RemoveEntry (const char *idname);
   /* Remove all entries */
   void RemoveAllEntries ();
   /* Check if there is any entries left */
   bool IsEmpty ();
   /* Get the first entry containing idname if it exist */
   bool GetEntry (const char *idname,int &type,int &value,bool &state,char *txt);
 private:
   /* Config file data */
   ConfigList *entries;
};

#endif
