#!/usr/bin/perl -w

my $dir = `pwd`;
chomp $dir;

my @makefiles = `find . -name "Makefile.am" -not -path "./modules/*" -not -path "./shaders/*"`;

for(@makefiles)
	{
		chomp;
		my $file = $_;
		my ($filedir) = ($file =~ /(.*)Makefile\.am$/);

		print "Processing $file\n";

		my $content = LoadFile($file);
		if($content eq '')
			{
				print "Couldn't open file for reading, skipped.\n";
				next;
			}

		# Suppress multi-lines ...
		$content =~ s/\r//g;
		$content =~ s/\\\s*\n[\s\n]*/ /g;

		# Get HEADERS list ...
		my ($headersname, $headers) = ($content =~ /^(.*)HEADERS\s*=\s*(.*)$/m);
		if(!defined $headers)
			{
				print " > no HEADERS list <\n";
				$headers = "";
			}

		my %files = ();
		for(split /\s/, $headers)
			{
				next if($_ eq '');

				# Save header name
				$files{$_} = 1;
			}

		# Check against real list ...
		for(FileList($filedir))
			{
				my $name = $_;

				# Skip non-header files
				next if($name !~ /\.h$/ && $name !~ /\.hpp$/ && $name !~ /\.ipp$/);

				if(!defined $files{$name})
					{
						print "  you must include $name !!\n";
					}
			}

	}


sub	LoadFile
{
	my ($filename) = @_;

	my $content = '';

	if(!open FH, "<$filename")
		{
			return $content;
		}

	while(<FH>)
		{
			$content .= $_;
		}

	close FH;

	return $content;
}


sub     FileList
{
	my $dir = shift;

	return () if(! opendir DIR, $dir);

	my @files = sort grep { -f "$dir/$_" } readdir DIR;
	close DIR;

	return @files;
}



