#ifndef K3DEMBED_PLUGIN_FACTORY_COLLECTION_H
#define K3DEMBED_PLUGIN_FACTORY_COLLECTION_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares plugin_factory_collection, an implementation of iplugin_factory_collection that can load plugin factories from shared libraries
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/iplugin_factory_collection.h>
#include <k3dsdk/signal_system.h>

#include <string>

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// plugin_factory_collection

/// Provides an implementation of iplugin_factory_collection that can load plugin factories from shared libraries
class plugin_factory_collection :
	public iplugin_factory_collection
{
public:
	/// Defines a signal emitted to display human-readable progress messages while loading plugin modules
	typedef SigC::Signal1<void, std::string> message_signal_t;
	message_signal_t& message_signal();

	/// Loads plugin modules from zero-to-many directories, optionally descending recursively into each directory
	void load_modules(const std::string& Paths, bool Recursive);

	// iplugin_factory_collection implementation
	const factories_t& factories();

private:
	message_signal_t m_message_signal;
	factories_t m_factories;
};

} // namespace k3d

#endif // !K3DEMBED_PLUGIN_FACTORY_COLLECTION_H

