#ifndef K3DSDK_ICOMMAND_TREE_H
#define K3DSDK_ICOMMAND_TREE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares icommand_tree, an abstract interface for a directed graph of icommand_tree objects
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iunknown.h"

#include "signal_system.h"

#include <vector>

namespace k3d
{

// Forward declarations
class icommand_node;

/// Abstract interface for a directed graph of icommand_tree objects
class icommand_tree :
	public virtual iunknown
{
public:
	/// Adds a node to the tree, setting its parent node
	virtual void add_node(icommand_node& Node, icommand_node& Parent) = 0;
	/// Removes a node from the tree
	virtual void remove_node(icommand_node& Node) = 0;

	/// Returns a node's parent (note: result could be NULL if it's the root node)
	virtual icommand_node* parent(icommand_node& Child) = 0;
	/// Returns every child of the given node
	typedef std::vector<icommand_node*> children_t;
	virtual const children_t children(icommand_node& Node) = 0;

	/// Defines a signal that will be emitted anytime the tree is modified
	typedef SigC::Signal0<void> changed_signal_t;
	virtual changed_signal_t& changed_signal() = 0;

protected:
	icommand_tree() {}
	icommand_tree(const icommand_tree& RHS) {}
	icommand_tree& operator = (const icommand_tree& RHS) { return *this; }
	virtual ~icommand_tree() {}
};

} // namespace k3d

#endif // K3DSDK_ICOMMANDTREE

