#ifndef K3DSDK_IHANDLE_H
#define K3DSDK_IHANDLE_H

#include "iunknown.h"
#include "signal_system.h"

namespace k3d
{

/// Abstract interface for a "handle" object that can be "grabbed" with the mouse pointer
class ihandle :
	public virtual iunknown
{
public:
	/// Called to notify the handle that it has been "grabbed" by the user
	virtual void grab() = 0;
	
	/// Signal for notifying observers that the handle has been grabbed
	typedef SigC::Signal0<void> grabbed_signal_t;
	virtual grabbed_signal_t& grabbed_signal() = 0;
	
	/// Signal for notifying observers that the handle has been released
	typedef SigC::Signal0<void> released_signal_t;
	virtual released_signal_t& released_signal() = 0;
	
protected:
	ihandle() {}
	ihandle(const ihandle&) {}
	ihandle& operator=(const ihandle&) { return *this; }
	virtual ~ihandle() {}
};

} // namespace k3d

#endif // !K3DSDK_IHANDLE_H
