#ifndef K3DSDK_ISNAP_TARGET_H
#define K3DSDK_ISNAP_TARGET_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares isnap_target, an abstract interface implemented by objects to which other objects can be interactively "snapped"
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iunknown.h"
#include "vectors.h"
#include <string>

namespace k3d
{

/// Abstract interface implemented by objects to which other objects can be interactively "snapped"
class isnap_target :
	public virtual iunknown
{
public:
	/// Maps 3D world coordinates into "snap" coordinates
	virtual void snap(const vector3& InputCoordinates, vector3& SnapCoordinates, std::string& SnapDescription) = 0;

protected:
	isnap_target() {}
	isnap_target(const isnap_target&) {}
	isnap_target& operator=(const isnap_target&) { return *this; }
	virtual ~isnap_target() {}
};

} // namespace k3d

#endif // K3DSDK_ISNAP_TARGET_H

