#ifndef K3DSDK_MESH_SOURCE_H
#define K3DSDK_MESH_SOURCE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "imesh_source.h"
#include "mesh.h"
#include "property_collection.h"
#include "selection.h"

namespace k3d
{

template<typename base_t>
class mesh_source :
	public base_t,
	public imesh_source
{
public:
	mesh_source(idocument& Document) :
		base_t(Document),
		m_output_mesh(init_name("output_mesh") + init_description("Output mesh [mesh]") + init_document(Document))
	{
		base_t::register_property(m_output_mesh);

		Document.selection().deselect_all_signal().connect(SigC::slot(*this, &mesh_source::on_deselect_all));
	}

	iproperty& mesh_source_output()
	{
		return m_output_mesh;
	}

protected:
	k3d_read_only_data_property(mesh*, immutable_name, change_signal, no_undo, demand_storage, no_constraint) m_output_mesh;

private:
	void on_deselect_all()
	{
		if(m_output_mesh.empty())
			return;
		k3d::deselect(base_t::document(), deep_selection(base_t::document().dag(), make_selection(*m_output_mesh.value())));
	}
};

} // namespace k3d

#endif // !K3DSDK_MESH_SOURCE_H


