#ifndef K3DSDK_UUID_H
#define K3DSDK_UUID_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <iosfwd>

namespace k3d
{

/// Globally unique identifier used to identify plugin objects for instantiation
class uuid
{
public:
	uuid(const unsigned long Data1, const unsigned long Data2, const unsigned long Data3, const unsigned long Data4) :
		data1(Data1),
		data2(Data2),
		data3(Data3),
		data4(Data4)
	{
	}

	static uuid null()
	{
		return uuid(0, 0, 0, 0);
	}

	friend bool operator < (const uuid& LHS, const uuid& RHS)
	{
		if(LHS.data1 == RHS.data1)
		{
			if(LHS.data2 == RHS.data2)
			{
				if(LHS.data3 == RHS.data3)
				{
					return LHS.data4 < RHS.data4;
				}
				else
					return LHS.data3 < RHS.data3;
			}
			else
				return LHS.data2 < RHS.data2;
		}

		return LHS.data1 < RHS.data1;
	}

	friend bool operator == (const uuid& LHS, const uuid& RHS)
	{
		return (LHS.data1 == RHS.data1) && (LHS.data2 == RHS.data2) && (LHS.data3 == RHS.data3) && (LHS.data4 == RHS.data4);
	}

	friend bool operator != (const uuid& LHS, const uuid& RHS)
	{
		return !(LHS == RHS);
	}

	friend std::ostream& operator<<(std::ostream& Stream, const uuid& Value);
	friend std::istream& operator>>(std::istream& Stream, uuid& Value);

private:
	unsigned long data1;
	unsigned long data2;
	unsigned long data3;
	unsigned long data4;
};

} // namespace k3d

#endif // K3DSDK_UUID_H

