#include <gtk/gtk.h>
#include <stdio.h>
#include "gtkurl.h"

/* This demonstrates the basic GtkUrl functionality:
 */

int main(int argc, char* argv[]) 
{
  GtkWidget *win;
  GtkWidget *vbox;
  GtkWidget *label;
  GtkWidget *text;
  GtkWidget *button;
  
  gtk_init(&argc, &argv);
  
  win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(win), 10);
  gtk_window_set_title(GTK_WINDOW(win), "GtkUrl - simple demo");
  gtk_signal_connect(GTK_OBJECT(win), "delete_event",
		     GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
  
  vbox = gtk_vbox_new(FALSE, 5);
  
  label = gtk_label_new("Type some text below.\n"
			"Try entering some URLs.\n"
			"Then right click on a highlighted word.");
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
  
  text = gtk_text_new(NULL, NULL);
  gtk_text_set_editable(GTK_TEXT(text), TRUE);
  gtkurl_attach(GTK_TEXT(text));
  
  gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
		  "Cool sites are http://freshmeat.net, www.kuro5hin.org and slashdot.org.", -1);
  
  gtkurl_check_all(GTK_TEXT(text));
  gtk_box_pack_start(GTK_BOX(vbox), text, TRUE, TRUE, 0);
  
  /* 	button = gtk_button_new_with_label("Run"); */
  /* 	gtk_signal_connect_object( GTK_OBJECT(button), "clicked", */
  /* 			    GTK_SIGNAL_FUNC(gtkurl_check_all), GTK_OBJECT(text) ); */
  /* 	gtk_box_pack_start(GTK_BOX(vbox), button, TRUE, TRUE, 0); */
  
  gtk_container_add(GTK_CONTAINER(win), vbox);
  gtk_widget_show_all(vbox);
  
  gtk_widget_show(win);
  
  gtk_main();
  
  return 0;
}
