// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements a joint within an ODE world
		\author Timothy M. Shead (tshead@k-3d.com)
		\author Brett W. McCoy (bmccoy@chapelperilous.net)
*/

#include "ijoint.h"

#include <k3dsdk/renderman.h>
#include <k3dsdk/transform.h>
#include <k3dsdk/persistence.h>
#include <k3dsdk/measurement.h>
#include <k3dsdk/module.h>

#include <sdpgl/sdpgl.h>

namespace
{

class hingejoint_implementation :
	public k3d::animate<k3d::editor::renderable<k3d::ri::renderable<k3d::transformable<k3d::persistent<k3d::object> > > > >,
	public libk3dode::ijoint
{
	typedef k3d::animate<k3d::editor::renderable<k3d::ri::renderable<k3d::transformable<k3d::persistent<k3d::object> > > > > base;
		
public:
	hingejoint_implementation(k3d::idocument& Document) :
		base(Document),
		m_anchorx(k3d::init_name("anchorx") + k3d::init_description("Anchor X [number]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::distance))),
		m_anchory(k3d::init_name("anchory") + k3d::init_description("Anchor Y [number]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::distance))),
		m_anchorz(k3d::init_name("anchorz") + k3d::init_description("Anchor Z [number]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::distance))),
		m_axis1x(k3d::init_name("axis1x") + k3d::init_description("Axis 1 X [number]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::distance))),
		m_axis1y(k3d::init_name("axis1y") + k3d::init_description("Axis 1 Y [number]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::distance))),
		m_axis1z(k3d::init_name("axis1z") + k3d::init_description("Axis 1 Z [number]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::distance))),
		m_axis2x(k3d::init_name("axis2x") + k3d::init_description("Axis 2 X [number]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::distance))),
		m_axis2y(k3d::init_name("axis2y") + k3d::init_description("Axis 2 Y [number]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::distance))),
		m_axis2z(k3d::init_name("axis2z") + k3d::init_description("Axis 2 Z [number]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::distance))),
		m_joint(0)
	{
	   enable_serialization(k3d::persistence::proxy(m_anchorx));
	   enable_serialization(k3d::persistence::proxy(m_anchory));
	   enable_serialization(k3d::persistence::proxy(m_anchory));
	   enable_serialization(k3d::persistence::proxy(m_axis1x));
	   enable_serialization(k3d::persistence::proxy(m_axis1y));
	   enable_serialization(k3d::persistence::proxy(m_axis1z));
	   enable_serialization(k3d::persistence::proxy(m_axis2x));
	   enable_serialization(k3d::persistence::proxy(m_axis2y));
	   enable_serialization(k3d::persistence::proxy(m_axis2z));

	   register_property(m_anchorx);
	   register_property(m_anchory);
	   register_property(m_anchorz);
	   register_property(m_axis1x);
	   register_property(m_axis1y);
	   register_property(m_axis1z);
	   register_property(m_axis2x);
	   register_property(m_axis2y);
	   register_property(m_axis2z);
	}

	const dJointID create(const dWorldID World, dJointGroupID JointGroup)
	{
	  if(m_joint) dJointDestroy(m_joint);
	  m_joint = dJointCreateHinge(World, JointGroup);
	  return m_joint;
	}
	
	void reset()
	{
	}
	
	void pre_step()
	{
	}
	
	void post_step()
	{
	}
	
	void destroy()
	{
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}
	
	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<k3d::document_plugin<hingejoint_implementation> > factory(
			k3d::uuid(0x85261cec, 0xe58c4062, 0xb6a38041, 0x57d57384),
			"ODEHingeJoint",
			"Experimental ODE dynamics library plugin",
			"Objects",
			k3d::iplugin_factory::EXPERIMENTAL);
		
		return factory;
	}

private:
	dJointID m_joint;

        k3d_measurement_property(double, 
				 k3d::immutable_name, 
				 k3d::change_signal, 
				 k3d::with_undo, 
				 k3d::local_storage, 
				 k3d::no_constraint) m_anchorx;
        k3d_measurement_property(double, 
				 k3d::immutable_name, 
				 k3d::change_signal, 
				 k3d::with_undo, 
				 k3d::local_storage, 
				 k3d::no_constraint) m_anchory;
        k3d_measurement_property(double, 
				 k3d::immutable_name, 
				 k3d::change_signal, 
				 k3d::with_undo, 
				 k3d::local_storage, 
				 k3d::no_constraint) m_anchorz;

        k3d_measurement_property(double, 
				 k3d::immutable_name, 
				 k3d::change_signal, 
				 k3d::with_undo, 
				 k3d::local_storage, 
				 k3d::no_constraint) m_axis1x;
        k3d_measurement_property(double, 
				 k3d::immutable_name, 
				 k3d::change_signal, 
				 k3d::with_undo, 
				 k3d::local_storage, 
				 k3d::no_constraint) m_axis1y;
        k3d_measurement_property(double, 
				 k3d::immutable_name, 
				 k3d::change_signal, 
				 k3d::with_undo, 
				 k3d::local_storage, 
				 k3d::no_constraint) m_axis1z;

        k3d_measurement_property(double, 
				 k3d::immutable_name, 
				 k3d::change_signal, 
				 k3d::with_undo, 
				 k3d::local_storage, 
				 k3d::no_constraint) m_axis2x;
        k3d_measurement_property(double, 
				 k3d::immutable_name, 
				 k3d::change_signal, 
				 k3d::with_undo, 
				 k3d::local_storage, 
				 k3d::no_constraint) m_axis2y;
        k3d_measurement_property(double, 
				 k3d::immutable_name, 
				 k3d::change_signal, 
				 k3d::with_undo, 
				 k3d::local_storage, 
				 k3d::no_constraint) m_axis2z;

};

} // namespace

namespace libk3dode
{

//////////////////////////////////////////////////////////////////////////////////////////
// hingejoint_factory

k3d::iplugin_factory& hingejoint_factory()
{
	return ::hingejoint_implementation::get_factory();
}

} // namespace libk3dode

