// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements the k3d::ri::render class, which provides a default implementation of k3d::ri::irender
		\author Tim Shead (tshead@k-3d.com)
		\author Romain Behar (romainbehar@yahoo.com)
*/

#include "renderman_types.h"

namespace k3d
{

namespace ri
{

///////////////////////////////////////////////////////////////////////////////////
// storage_class_t
	
std::ostream& operator<<(std::ostream& Stream, const storage_class_t RHS)
{
	switch(RHS)
	{
		case k3d::ri::CONSTANT:
			Stream << "constant";
			break;
		case k3d::ri::UNIFORM:
			Stream << "uniform";
			break;
		case k3d::ri::VARYING:
			Stream << "varying";
			break;
		case k3d::ri::VERTEX:
			Stream << "vertex";
			break;
		case k3d::ri::FACEVARYING:
			Stream << "facevarying";
			break;
		default:
			assert_not_reached();
	}

	return Stream;
}

//////////////////////////////////////////////////////////////////////////////////////
// parameter_list

parameter_list& operator+=(parameter_list& LHS, const parameter_list& RHS)
{
	LHS.insert(LHS.end(), RHS.begin(), RHS.end());
	return LHS;
}

parameter_list operator+(const parameter_list& LHS, const parameter_list& RHS)
{
	parameter_list results(LHS);
	results += RHS;

	return results;
}

} // namespace ri

} // namespace k3d

