/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
/*
   Authors:
   Alek Wojdyga <pinkworm@alan.umcs.lublin.pl>
   Marcin lusarz <mslusarz@alan.umcs.lublin.pl>
   Vogel <poczta@vogel.w.pl>
   
   http://alan.umcs.lublin.pl/~pinkworm/dcopexport/
*/

#ifndef DCOPEXPORT_H
#define DCOPEXPORT_H

#include <qprocess.h>
#include "DCOPExportIface.h"

/**
 * Export niektrych funkcji Kadu do DCOP
 **/
class DCOPExport : public QObject, virtual public DCOPExportIface
{
	Q_OBJECT

	public:
		DCOPExport ();
		~DCOPExport ();

		virtual void sendMessage (const QString &uin, const QString &message);
		virtual void sendMessageWithHistory (const QString &uin, const QString &message);

		virtual QStringList getGroups ();
		virtual QStringList getUsersInGroup (QString group);
		virtual QStringList getUserInfo (QString uin);

		virtual QString description ();
		virtual void setDescription (QString desc);

		virtual void setOnline ();
		virtual void setOnline (const QString& desc);
		virtual bool isOnline ();

		virtual void setBusy ();
		virtual void setBusy (const QString& desc);
		virtual bool isBusy ();

		virtual void setInvisible ();
		virtual void setInvisible (const QString& desc);
		virtual bool isInvisible ();

		virtual void setOffline ();
		virtual void setOffline (const QString& desc);
		virtual bool isOffline ();

		virtual void setFriendsOnly (bool b);
		virtual bool isFriendsOnly ();

		virtual void openChat(QString uins);

		virtual void openSearchDialog (QString uin);
		virtual void showHistory (QString uins);

		virtual void openUrl (const QString& url);

		virtual void showMessage (QString type, QString text);
		virtual QStringList getMessageTypes ();

		virtual QString readEntry (const QString &group, const QString &name, const QString &def = QString::null);
		virtual int readNumEntry (const QString &group, const QString &name, int def = 0);
		virtual double readDoubleNumEntry (const QString &group, const QString &name, double def = 0.0);
		virtual bool readBoolEntry (const QString &group, const QString &name, bool def = false);
		virtual QString passwordHash (const QString &s);

		virtual void writeEntry(const QString &group, const QString &name, const QString &value);
		virtual void sendFile (const QString &uin, const QString &path);
		
		virtual bool exportUserList ();

		virtual bool sendUserSMS (const QString &sender, const QString &altnick, const QString &message);
		virtual bool sendSMS (const QString &sender, const QString &number, const QString &message);

		virtual void quit ();

	private:
		DCOPClient *dcopclient;
		QCString appId;
		QProcess *installGGProcess; // sluzy rowniez do instalacji kaduSetDescription.desktop
		void cleanupForKadu ();
		void connectToDCOP (bool qtdcopbridge, bool acceptforeigncalls);

	private slots:
		void attachFailed (const QString &msg);
		void installGGInKonqueror ();
		void installGGInFirefox ();
		void installGGInOpera ();
		void installKaduSetDescription ();
		void installGGProcessExited();

	public slots:
		void applyConfig ();
};

extern DCOPExport *dcopexport;

#endif // DCOPEXPORT_H
