#include <string>
#include <vector>
#include <iostream>
using namespace std;

#include "addressing.h"
#include "utility.h"
#include "globals.h"
#include "errors.h"

int parseAddress( string address, int &p_dii, string &p_extdir, string &p_file, string &p_intdir )
{
//	if( !checkingstructure ) cout << "PARSE |" << address << "|" << endl;

        p_dii = FALSE;
        p_extdir = p_file = p_intdir = "";
        string site;
        string rest;
        vector<string> mirrorv;
        int i;
	unsigned int j;
        vector<string> dirs;

        // save mirror locations

        if( ( i = address.find_last_of( ',' ) ) != -1 )
        {
		dirToVec( address.substr( 0, i ), mirrorv, ',', FALSE );
                address = trim( address.substr( i+1, address.length()-i-1 ) );
        }

        // internal absolute address

        if( address.find_first_of( '/' ) == 0 )
        {
                dirToVec( address.substr( 1, address.length()-1 ), dirs, '/', FALSE );

		if( !vecHasDot( dirs ) )
		{	
			p_intdir = address;
			return TRUE;
		}	
        } 

        // check if address starts with absolute 'site'

        if( address.find( "http://" ) == 0 )
        {
                // http://ms.com
                if( ( i = address.find_first_of( '/', 7 ) ) == -1 )
                {
                        p_extdir = address;
                        return TRUE;
                }

                site = address.substr( 0, i+1 );
                rest = address.substr( i+1, address.length()-i-1 );
        }
        else if( ( address.find( ":/" ) == 1 ) &&
                 ( address[0] >= 'A' ) &&
                 ( address[0] <= 'z' ) )
        {
                site = address.substr( 0, 3 );
                rest = address.substr( 3, address.length()-3 );
        }
        else if( address.find( "/" ) == 0 )
        {
                site = "/";
                rest = address.substr( 1, address.length()-1 );
        }

	// handle absolute addresses
	
        if( site != "" )
        {
                dirToVec( rest, dirs, '/', FALSE );

                if( !vecHasDii( dirs, j ) )
                {
                        p_extdir = address;
                        return TRUE;
                }

        	if( mirrorv.size() )
			for( unsigned int n = 0; n < mirrorv.size(); n++ )
			{
				if( !compactPath( mirrorv[n], dirs[j] ) )
					return FALSE;
				p_extdir += mirrorv[n] + ",";
        		}
		
		string location = slashConcat( site, vecToDir( dirs, 0, j, "/" ) );
		if( !compactPath( location, dirs[j] ) )
			return FALSE;

		p_dii = TRUE;
                p_extdir += location;
                p_file = dirs[j];
                p_intdir = vecToDir( dirs, j+1, dirs.size()-j-1, "/" );

                return TRUE;
        }

        // handle relative addresses

        dirToVec( address, dirs, '/', FALSE );

        // internal relative

        if( !vecHasDot( dirs ) )
        {
                p_intdir = address;
                return TRUE;
        }

        // external relative

	if( !vecHasDii( dirs, j ) )
	{
		p_extdir = slashConcat( cPath, address );
		return TRUE;
	}
	
        if( mirrorv.size() )
		for( unsigned int n = 0; n < mirrorv.size(); n++ )
		{	
			string mirror = slashConcat( cPath, mirrorv[n] );
			if( !compactPath( mirror, dirs[j] ) )
				return FALSE;
                        p_extdir += mirror + ",";
                }
	
        p_dii = TRUE;
        p_extdir += slashConcat( cPath, vecToDir( dirs, 0, j, "/" ) );
        p_file = dirs[j];
        p_intdir = vecToDir( dirs, j+1, dirs.size()-j-1, "/" );

        return compactPath( p_extdir, p_file );
}

int compactPath( string &path, string file )
{
//        if( !checkingstructure ) cout << "COMPACT PATH " + path << endl;

        string site;
        string rest = path;
        int i;

        // first, remove site

        if( path.find( "http://" ) == 0 )
        {
                i = path.find_first_of( '/', 7 );

                site = path.substr( 0, i+1 );
                rest = path.substr( i+1, path.length()-i-1 );
        }
        else if( ( path.find( ":/" ) == 1 ) &&
                 ( path[0] >= 'A' ) &&
                 ( path[0] <= 'z' ) )
        {
                site = path.substr( 0, 3 );
                rest = path.substr( 3, path.length()-3 );
        }
        else if( path.find( "/" ) == 0 )
        {
                site = "/";
                rest = path.substr( 1, path.length()-1 );
        }

        // compact rest

        vector<string> dirv;
        dirToVec( rest, dirv, '/', FALSE );

        int foundone;
        do
        {
                foundone = FALSE;

                for( unsigned int n = 0; n < dirv.size(); n++ )
                        if( dirv[n] == "." )
                        {
                                dirv.erase( dirv.begin()+n, dirv.begin()+n+1 );
                                foundone = TRUE;
                        }
                        else if( ( dirv[n] == ".." ) &&
                                 ( n != 0 ) &&
                                 ( dirv[n-1] != ".." ) )
                        {
                                dirv.erase( dirv.begin()+n-1, dirv.begin()+n+1 );
                                foundone = TRUE;
                        }
        }
        while( foundone );

        path = site + vecToDir( dirv, 0, dirv.size(), "/" );

        if( ( dirv.size() != 0 ) &&
            ( dirv[0] == ".." ) &&
            ( site != "" ) )
        {
                showNavigationError( slashConcat( path, file ) + ":\n" + "nonsensical address" );
                return FALSE;
        }

        return TRUE;
}

