/***************************************************************************
                          advanced.cpp  -  description
                             -------------------
    begin                : Wed May 24 2000
    copyright            : (C) 2000 by mark dufour
    email                : m.dufour@twi.tudelft.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "advanced.h"
#include "keybox.h"

#include <qstring.h>

advanced::advanced(QWidget *parent, const char *name) : QWidget(parent,name)
{
	initDialog();

	QObject::connect( LBkeybindings, SIGNAL( selected( const QString & ) ), this, SLOT( keySelected( const QString & ) ) );
	QObject::connect( Bdefaultkeys, SIGNAL( clicked() ), this, SLOT( defaultKeys() ) );
	QObject::connect( Bvistylekeys, SIGNAL( clicked() ), this, SLOT( vistyleKeys() ) );
}

void advanced::keySelected( const QString &key )
{
	KeyBox k( this );
	if( k.exec() )
	{
		string text = (const char *)key;
		text = text.substr( 0, text.find( "=" )-1 );

		int option = getKey( text );

		for( unsigned int n = 0; n < keyBindingv.size(); n += 2 )
			if( keyBindingv[n] == option )
			{
				keyBindingv[n+1] = k.key;
				fillListBox();	
				LBkeybindings->setCurrentItem( n/2 );

				break;
			}	
				
	}	

}

void advanced::fillListBox()
{
	LBkeybindings->clear();

	for( unsigned int n = 0; n < textv.size(); n++ )
	{
		string newitem = textv[n] + " = ";

		int key = getKey( textv[n] );

		for( unsigned int m = 0; m < keyBindingv.size(); m += 2 )
			if( keyBindingv[m] == key )
			{
				newitem += textForKey( keyBindingv[m+1] );
				break;
			}	
			
		LBkeybindings->insertItem( newitem.c_str() );	
	}
}

string advanced::textForKey( int key )
{
	if( key == Key_Left ) return "Left";
	if( key == Key_Right ) return "Right";
	if( key == Key_Up ) return "Up";
	if( key == Key_Down ) return "Down";
	if( key == Key_Space ) return "Space";
	if( key == Key_Enter ) return "Enter";
	if( key == Key_Home ) return "Home";
	if( key == Key_End ) return "End";
	if( key == Key_Escape ) return "Escape";
	if( key == Key_PageDown ) return "PgDn";
	if( key == Key_PageUp ) return "PgUp";
	if( key == Key_Alt ) return "Alt";
	if( key == Key_Control ) return "Control";
	if( key == Key_Meta ) return "Meta";
	if( key == Key_Shift ) return "Shift";

	string s = " ";
	s[0] = key;
	return s;
}

int advanced::getKey( string s )
{
	for( unsigned int n = 0; n < textv.size(); n++ )
		if( textv[n] == s )
			return keyv[n];
			
	return -1;		 
}

void advanced::defaultKeys()
{
	textv.clear();
	keyv.clear();
	keyBindingv.clear();

	addKeyBindings( FALSE );
	fillListBox();
}

void advanced::vistyleKeys()
{
	textv.clear();
	keyv.clear();
	keyBindingv.clear();

	addKeyBindings( TRUE );
	fillListBox();
}

void advanced::addKeyBindings( int vi )
{
	addBinding( "Add Bookmark", Key_A );
  	addBinding( "Back", vi, Key_H, Key_Left );
	addBinding( "Bases", Key_B );
  	addBinding( "Chat", Key_C );
	addBinding( "Clear Cache", Key_E );
	addBinding( "Debug Window", Key_Z );
	addBinding( "Discuss", Key_D );
  	addBinding( "Enter", vi, Key_L, Key_Right );
	addBinding( "Faqs", Key_Q );
  	addBinding( "First Category", Key_Home );
  	addBinding( "Forward", Key_F );
	addBinding( "Information", Key_I );
  	addBinding( "Last Category", Key_End );
	addBinding( "Links", Key_G );
	addBinding( "Mailing Lists", Key_Y );
	addBinding( "Mark", Key_M );
  	addBinding( "New Search", Key_R );
	addBinding( "News", Key_N );
  	addBinding( "Next Category", vi, Key_J, Key_Down );
  	addBinding( "Next Page", Key_PageDown );
	addBinding( "Open File", Key_O );
	addBinding( "Open URL", Key_U );
  	addBinding( "Open With", Key_W );
  	addBinding( "Preferences", Key_P );
  	addBinding( "Prev Category", vi, Key_K, Key_Up );
  	addBinding( "Prev Page", Key_PageUp );
  	addBinding( "Quit", Key_X );
	addBinding( "View Bookmarks", Key_V );
  	addBinding( "View Source", Key_S );
	addBinding( "To Mark", Key_T );
}

void advanced::addBinding( string text, int key )
{
	textv.push_back( text );
	keyv.push_back( key );

	keyBindingv.push_back( key );
	keyBindingv.push_back( key );
}

void advanced::addBinding( string text, int vi, int key1, int key2 )
{
	if( !vi )
	{
		addBinding( text, key2 );
		return;
	}	
	
	textv.push_back( text );
	keyv.push_back( key2 );

	keyBindingv.push_back( key2 );
	keyBindingv.push_back( key1 );
}

advanced::~advanced(){
}
