#include <string>
#include <vector>
#include <iostream>

using namespace std;

#ifdef GUI
#include <qapplication.h>

#include "browser.h"
#include "preferences.h"
#endif

#include "navigation.h"
#include "category.h"
#include "globals.h"
#include "errors.h"

int main( int argc, char **argv )
{
  checkingstructure = FALSE;

#ifdef GUI // start browser in graphics mode

  myapp = new QApplication( argc, argv );

  if( argc > 1)
  {
    if ( ( strlen( argv[1]) < 4 ) || 
         ( strcmp( argv[1] + strlen(argv[1]) - 4, ".dii") != 0 ) )
    {
      cout << "Usage: kascade [FILE]\n kascade version 1 beta9" << endl;
      exit(0);
    }
  }


  config = new Preferences();
  browser = new Browser();

  myapp->setMainWidget( browser );
  browser->show();

  string start = ( argc > 1 ) ? argv[1] : config->startAddress();

  if( clear_goto( start ) )
  {
    browser->showNewCategory(); 

    showParseWarnings();
    parsewarningv.clear();
  } 

  browser->disabled = FALSE;
  return myapp->exec(); 

#else   // start browser in text mode

  if( clear_goto( "dii/root.dii" ) )
  {
    showParseWarnings();
    parsewarningv.clear();

    cCategory->visited = TRUE;

    traverseDII();
  }
#endif 
}
