#include <algorithm>
#include <iostream>
using namespace std;

#include "category.h"
#include "currents.h"
#include "globals.h"
#include "summation.h"
#include "navigation.h"
#include "addressing.h"
#include "exprnode.h"
#include "expression.h"

int expandSummation( Category *cat )
{
	//cout << "expand " << cat->name << endl;

	Currents c; c.save();

    	vector<string> donev, exprv, critv;
    	vector<Category *> linearList;

    	if( cat->data1v != 0 )
        	for( unsigned int n = 0; n < cat->data1v->size(); n++ )
            		exprv.push_back( (*(cat->data1v))[n] );
    	if( cat->data2v != 0 )
        	for( unsigned int n = 0; n < cat->data2v->size(); n++ )
            		critv.push_back( (*(cat->data2v))[n] ); 
#ifndef GUI        
	for( unsigned int n = 0; n < exprv.size(); n++ )
        	cout << "exprv " << exprv[n] << endl;
	for( unsigned int n = 0; n < critv.size(); n++ )
        	cout << "critv " << critv[n] << endl;
#endif		 

    	if( !( gotoAddress( cat->target ) &&
               addRealSubCats( cCategory, linearList, cCategory ) &&
               removeExcludedCategories( exprv, linearList ) &&
               expandRecursive( cat, critv, donev, linearList, cat->title ) ) ) 
    	{
        	c.load();
        	cat->expanded = FALSE;
        	return FALSE;
    	}

	sortCategories( cat );

    	cat->target = "";
	cat->expanded = TRUE;
	c.load();
    	return TRUE;
}

int removeExcludedCategories( vector<string> &propertyv,
    vector<Category *> &linearList )
{
    	vector<Category *> newList;
   	vector<ExprNode *> exprv;

	// build expression trees
	
    	for( unsigned int n = 0; n < propertyv.size(); n++ )
	{	
        	ExprNode *expr;
		if( !( expr = createExprTree( propertyv[n] ) ) )
		{	
			for( unsigned int m = 0; m < exprv.size(); m++ )
				delete exprv[m];
			return FALSE;
		}
		
		exprv.push_back( expr );
	}

	// evaluate them for each category
	
	for( unsigned int m = 0; m < linearList.size(); m++ )
	{	
		int exprtrue = TRUE;
		for( unsigned int n = 0; n < exprv.size(); n++ )
			if( !exprTrueForCategory( exprv[n], linearList[m] ) )
			{
				exprtrue = FALSE;
				break;
			}
				
		if( exprtrue )
			newList.push_back( linearList[m] );
	}

	for( unsigned int n = 0; n < exprv.size(); n++ )
		delete exprv[n];

        linearList = newList;
    	return TRUE;
}

int expandRecursive( Category *superCat, vector<string> &propertyv,
    vector<string> &donev, vector<Category *> &linearList, string targettitle )
{
    	if( propertyv.empty() )
    	{
        	superCat->title = targettitle;
		superCat->aliasedsubcats = TRUE;

        	for( int n = 0; n < linearList.size(); n++ )
            		if( categoryDone( donev, linearList[n] ) &&
                	    !superCat->subCatExists( linearList[n]->name ) )
                		superCat->addSubcat( linearList[n] );

	        return TRUE;
    	}

    	superCat->title = "select " + propertyv[0];

    	for( int n = 0; n < linearList.size(); n++ )
    	{
        	if( !categoryDone( donev, linearList[n] ) )
            		continue;

	        vector<string> valuev = linearList[n]->getPropertyValues( propertyv[0] );

        	for( int n = 0; n < valuev.size(); n++ )
	        {
            		string property = valuev[n];

            		if( !superCat->subCatExists( property ) )
            		{
                		Category *newCat = superCat->addNewCat( property );

	                	donev.push_back( propertyv[0] );
		                donev.push_back( "=" );
		                donev.push_back( property );
		                string tempProp = propertyv[0];
		                propertyv.erase( propertyv.begin(), propertyv.begin()+1 );

	        	        expandRecursive( newCat, propertyv, donev, linearList, targettitle );

		                donev.pop_back();
		                donev.pop_back();
	        	        donev.pop_back();
		                propertyv.insert( propertyv.begin(), tempProp );
            		}
        	}
    	}

    	return TRUE;
}

int categoryDone( vector<string> &donev, Category *category )
{
    	for( int n = 0; n < donev.size(); n += 3 )
        	if( !category->hasPropertyWithValue( donev[n], donev[n+1], donev[n+2] ) )
            		return FALSE;

    	return TRUE;
}

int addRealSubCats( Category *category, vector<Category *> &linearList, Category *rootCat )
{
    	if( category->transsummation )
    	{
        	Currents c; c.save();

		loopCatv.clear();
        	if( !gotoAddress( category->target ) )
        	{
            		c.load();
            		return FALSE;
        	}

        	if( !addRealSubCats( cCategory, linearList, rootCat ) )
        	{
            		c.load();
            		return FALSE;
        	}

        	c.load();
        	return TRUE;
    	}

    	if( category->realsubcat &&
	    ( category != rootCat ) )
    	{
        	linearList.push_back( category );
        	return TRUE;
    	}

    	if( category->summation )
		return TRUE;

    	if( category->subCatv != 0 )
        	for( unsigned int n = 0; n < category->subCatv->size(); n++ )
            		if( !addRealSubCats( (*(category->subCatv))[n], linearList, rootCat ) )
                		return FALSE;
    	return TRUE;
}

void sortCategories( Category *cat )
{
	if( cat->subCatv == 0 )
		return;

        sort( cat->subCatv->begin(), cat->subCatv->end(), compareCategoryNames );
	
	for( unsigned int n = 0; n < cat->subCatv->size(); n++ )
		sortCategories( (*(cat->subCatv))[n] );		
}

int compareCategoryNames( Category *c1, Category *c2 )
{
        return c1->name < c2->name;
}

