#ifndef _TLSGLUE_H // -*-C++-*-
#define _TLSGLUE_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
#include <winsock2.h>
#include <ws2tcpip.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#endif

#include <gnutls/gnutls.h>
#include <VMState.h>
#include "network_glue.h"

extern "C" {
  void* do_gnutls_makecred();
  void* do_gnutls_init(void* cred);
  int do_gnutls_transport(void* tls, void* conn);
  void do_gnutls_put(void* tls, wchar_t* rawdat);
  wchar_t* do_gnutls_get(void* tls, void* vmptr);
  void do_gnutls_close(void* tls, void* cred);
}

#endif
