/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-base-menu-item.h 3236 2007-09-20 23:41:10Z ikezoe $
 */

#ifndef __KZ_BOOKMARK_BASE_MENU_ITEM_H__
#define __KZ_BOOKMARK_BASE_MENU_ITEM_H__

#include <gtk/gtk.h>
#include <kz-window.h>
#include <kz-bookmark.h>

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_BASE_MENU_ITEM		(kz_bookmark_base_menu_item_get_type ())
#define KZ_BOOKMARK_BASE_MENU_ITEM(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_BASE_MENU_ITEM, KzBookmarkBaseMenuItem))
#define KZ_BOOKMARK_BASE_MENU_ITEM_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_BOOKMARK_BASE_MENU_ITEM, KzBookmarkBaseMenuItemClass))
#define KZ_IS_BOOKMARK_BASE_MENU_ITEM(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_BASE_MENU_ITEM))
#define KZ_IS_BOOKMARK_BASE_MENU_ITEM_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_BOOKMARK_BASE_MENU_ITEM))
#define KZ_BOOKMARK_BASE_MENU_ITEM_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_BOOKMARK_BASE_ITEM, KzBookmarkBaseMenuItemClass))

typedef struct _KzBookmarkBaseMenuItem           KzBookmarkBaseMenuItem;
typedef struct _KzBookmarkBaseMenuItemClass      KzBookmarkBaseMenuItemClass;

struct _KzBookmarkBaseMenuItem
{
	GtkImageMenuItem parent;

	KzWindow        *kz;
	KzBookmark      *bookmark;
};

struct _KzBookmarkBaseMenuItemClass
{
	GtkImageMenuItemClass parent_class;
};

GType        kz_bookmark_base_menu_item_get_type (void) G_GNUC_CONST;

G_END_DECLS

#endif /* __KZ_BOOKMARK_BASE_MENU_ITEM_H__ */
