/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_WEB_H__
#define __KZ_WEB_H__

#include <gtk/gtk.h>
#include "kz-navi.h"
#include "egg-pixbuf-thumbnail.h"

G_BEGIN_DECLS

#define KZ_TYPE_WEB             (kz_web_get_type ())
#define KZ_WEB(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_WEB, KzWeb))
#define KZ_WEB_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_WEB, KzWebClass))
#define KZ_IS_WEB(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_WEB))
#define KZ_IS_WEB_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_WEB))
#define KZ_WEB_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_WEB, KzWebClass))

typedef enum {
	KZ_WEB_NORMAL_FLAG = 0,
	KZ_WEB_SOURCE_FLAG = 1 << 0
} KzWebLoadFlag;

typedef enum {
	KZ_WEB_RELOAD_NORMAL                 = 0,
	KZ_WEB_RELOAD_BYPASS_CACHE           = 1,
	KZ_WEB_RELOAD_BYPASS_PROXY           = 2,
	KZ_WEB_RELOAD_BYPASS_PROXY_AND_CACHE = 3,
	KZ_WEB_RELOAD_CHARSET_CHANGE         = 4
} KzWebReloadFlag;

typedef enum {
	KZ_WEB_GO_NONE,
	KZ_WEB_GO_BACK,
	KZ_WEB_GO_FORWARD,
	KZ_WEB_GO_UP,
	KZ_WEB_GO_INDEX,
	KZ_WEB_GO_CONTENTS,
	KZ_WEB_GO_START,
	KZ_WEB_GO_PREV,
	KZ_WEB_GO_NEXT
} KzWebGoAction;

typedef enum {
	KZ_WEB_LINK_NEXT,
	KZ_WEB_LINK_PREV,
	KZ_WEB_LINK_INDEX,
	KZ_WEB_LINK_CONTENTS,
	KZ_WEB_LINK_START,
	KZ_WEB_LINK_RSS,
	KZ_WEB_LINK_GUARD
} KzWebNavLink;

typedef struct _KzWeb           KzWeb;
typedef struct _KzWebClass      KzWebClass;

struct _KzWeb
{
    GtkBin parent;
};

struct _KzWebClass
{
    GtkBinClass parent_class;
};

GType        kz_web_get_type             (void) G_GNUC_CONST;
GtkWidget   *kz_web_new                  (const gchar *module_name,
                                          const gchar *engine_name);
const gchar *kz_web_get_engine_name      (KzWeb *web);
const gchar *kz_web_get_module_name      (KzWeb *web);
void         kz_web_change_engine        (KzWeb *web,
                                          const gchar *new_engine_name);
void         kz_web_load_uri             (KzWeb *web,
                                          const gchar *uri);
const gchar *kz_web_get_title            (KzWeb *web);
const gchar *kz_web_get_location         (KzWeb *web);
gdouble      kz_web_get_progress         (KzWeb *web);
gboolean     kz_web_get_lock             (KzWeb *web);
void         kz_web_set_lock             (KzWeb *web,
                                          gboolean lock);
gboolean     kz_web_get_allow_javascript (KzWeb *web);
void         kz_web_set_allow_javascript (KzWeb *web,
                                          gboolean enable);
gboolean     kz_web_is_loading           (KzWeb *web);
void         kz_web_view_source		     (KzWeb *web,
                                          const gchar  *url);
void         kz_web_view_current_page_source_in_new
                                         (KzWeb *web,
                                          KzWeb *new_embed);
gchar	    *kz_web_ensure_title         (KzWeb *web);
gboolean     kz_web_can_cut_selection    (KzWeb *web);
gboolean     kz_web_can_copy_selection   (KzWeb *web);
gboolean     kz_web_can_paste            (KzWeb *web);
void	     kz_web_cut_selection        (KzWeb *web);
void	     kz_web_copy_selection       (KzWeb *web);
void	     kz_web_paste                (KzWeb *web);
void	     kz_web_select_all           (KzWeb *web);
gchar       *kz_web_get_selection_string (KzWeb *web);
gboolean     kz_web_find                 (KzWeb *web,
                                          const gchar *keyword,
                                          gboolean backward);
gboolean     kz_web_incremental_search   (KzWeb *web,
                                          const gchar *keyword,
                                          gboolean backward);
gboolean     kz_web_selection_is_collapsed
                                         (KzWeb *web);
gboolean     kz_web_get_links            (KzWeb *web,
                                          GList **list,
                                          gboolean selected_only);
gboolean     kz_web_get_dest_anchors     (KzWeb *web,
                                          GList **list);
void         kz_web_copy_page            (KzWeb *src_embed,
                                          KzWeb *dest_embed);
gboolean    kz_web_shistory_get_pos      (KzWeb *web,
                                          gint *pos,
                                          gint *count);
void        kz_web_shistory_get_nth	     (KzWeb *web, 
                                          gint nth,
                                          gboolean is_relative,
                                          gchar **uri,
                                          gchar **title);
void        kz_web_reload                (KzWeb *web,
                                          KzWebReloadFlag flags);
void        kz_web_stop_load             (KzWeb *web);
void        kz_web_go_back               (KzWeb *web);
void        kz_web_go_forward            (KzWeb *web);
void        kz_web_go_up                 (KzWeb *web);
gboolean    kz_web_can_go_back           (KzWeb *web);
gboolean    kz_web_can_go_forward        (KzWeb *web);
gboolean    kz_web_can_go_up             (KzWeb *web);
gboolean    kz_web_can_go_nav_link       (KzWeb *web,
                                          KzWebNavLink link);
void        kz_web_go_nav_link           (KzWeb *web,
                                          KzWebNavLink link);
void        kz_web_append_nav_link	     (KzWeb *web,
                                          KzWebNavLink link,
                                          KzNavi *navi);
void        kz_web_set_nav_link		     (KzWeb *web,
                                          KzWebNavLink link,
                                          KzNavi *navi);
void        kz_web_set_nth_nav_link	     (KzWeb *web,
                                          KzWebNavLink link,
                                          KzNavi *navi,
                                          guint n);
KzNavi     *kz_web_get_nav_link          (KzWeb *web,
                                          KzWebNavLink link);
KzNavi     *kz_web_get_nth_nav_link      (KzWeb *web,
                                          KzWebNavLink link,
                                          guint n);
GList      *kz_web_get_nav_links         (KzWeb *web,
                                          KzWebNavLink link);
void        kz_web_go_history_index      (KzWeb *web,
                                          gint index);
gchar      *kz_web_get_body_text         (KzWeb *web);
void        kz_web_set_encoding          (KzWeb *web,
                                          const gchar *encoding);
void        kz_web_get_encoding          (KzWeb *web,
                                          gchar **encoding,
                                          gboolean *forced);
void        kz_web_print                 (KzWeb *web);
void        kz_web_print_preview         (KzWeb *web);
GList      *kz_web_get_printer_list      (KzWeb *web);
void        kz_web_create_thumbnail      (KzWeb *web,
                                          EggPixbufThumbnailSize size);
gboolean    kz_web_save_with_content     (KzWeb *web,
                                          const char *rawfilename);
gboolean    kz_web_set_text_into_textarea(KzWeb *web,
                                          gpointer element,
                                          const gchar *text);
gchar      *kz_web_get_text_from_textarea(KzWeb *web,
                                          gpointer element);
void        kz_web_zoom                  (KzWeb *web, 
                                          gdouble zoom);
gdouble     kz_web_get_zoom_ratio        (KzWeb *web);
void        kz_web_set_text_size         (KzWeb *web, 
                                          gdouble zoom);
gdouble     kz_web_get_text_size         (KzWeb *web);
gchar      *kz_web_get_html_with_contents(KzWeb *web,
                                          const gchar *storedir);
void        kz_web_set_history           (KzWeb *web,
                                          const GList *history,
                                          guint current_position);
void        kz_web_get_history           (KzWeb*web,
                                          GList **history,
                                          guint *current_position);
guint       kz_web_get_last_modified     (KzWeb*web);	
void        kz_web_fine_scroll           (KzWeb*web,
                                          gint horiz,
                                          gint vert);
void        kz_web_page_up               (KzWeb*web);
void        kz_web_page_down             (KzWeb*web);
gboolean    kz_web_get_allow_javascript  (KzWeb *web);
void        kz_web_set_allow_javascript  (KzWeb *web,
                                          gboolean allow);
gboolean    kz_web_get_allow_images	     (KzWeb *web);
void        kz_web_set_allow_images	     (KzWeb *web,
                                          gboolean allow);
void        kz_web_show_page_certificate (KzWeb *web);

G_END_DECLS

#endif /* __KZ_WEB_H__ */
/* 
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
