/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_PANED_H__
#define __KZ_PANED_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define KZ_TYPE_PANED		(kz_paned_get_type ())
#define KZ_PANED(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_PANED, KzPaned))
#define KZ_PANED_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_PANED, KzPanedClass))
#define KZ_IS_PANED(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_PANED))
#define KZ_IS_PANED_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_PANED))
#define KZ_PANED_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_PANED, KzPanedClass))

typedef struct _KzPaned           KzPaned;
typedef struct _KzPanedClass      KzPanedClass;

struct _KzPaned
{
	GtkPaned parent;
	
	GtkPositionType position; /* sidebar position */
};

struct _KzPanedClass
{
	GtkPanedClass parent_class;
	
	/* signals */
	void (*changed_position)  (KzPaned *kzpaned, GtkPositionType position);
};

GType      kz_paned_get_type (void) G_GNUC_CONST;
GtkWidget *kz_paned_new      (void);

gboolean   kz_paned_is_showing_all_children (KzPaned *kzpaned);
void       kz_paned_set_separator_position (KzPaned *kzpaned, gint position);
void       kz_paned_set_position  (KzPaned *kzpaned, GtkPositionType position);

G_END_DECLS

#endif /* __KZ_PANED_H__ */
