#include "kz-profile.h"

#include <gcutter.h>
#include <string.h>

#include "kz-test-utils.h"

void test_open (void);
void test_changed_signal (void);

static KzProfile *profile;
static gchar *file_path;

static gint n_changed_received;
static gchar *actual_old_value;
static gchar *actual_key;
static gchar *actual_section;

void
setup (void)
{
    profile = NULL;
    actual_old_value = NULL;
    actual_section = NULL;
    actual_key = NULL;

    n_changed_received = 0;

    file_path = g_build_filename(kz_test_get_base_dir(),
                                 "fixtures", "kzrc",
                                 NULL);
}

void
teardown (void)
{
    if (profile)
        g_object_unref(profile);
    g_free(actual_old_value);
    g_free(actual_section);
    g_free(actual_key);
    g_free(file_path);
}

void
test_open (void)
{
    profile = kz_profile_open(file_path, NULL);
    cut_assert(profile);
    kz_profile_set_auto_save(profile, FALSE);
}

static void
cb_changed (KzProfile *profile,
            const gchar *section, const gchar *key,
            const gchar *old_value, gpointer data)
{
    n_changed_received++;

    actual_old_value = g_strdup(old_value);
    actual_section = g_strdup(section);
    actual_key = g_strdup(key);
}

static void
setup_signals (void)
{
    g_signal_connect(profile, "changed", G_CALLBACK(cb_changed), NULL);
        
}

void
test_changed_signal (void)
{
    cut_trace(test_open());

    setup_signals();
    cut_assert_equal_string("beginner",
                            kz_profile_get_string(profile, "Global", "ui_level"));

    kz_profile_set_value(profile, "Global", "ui_level",
                         "unknown", strlen("unknown"),
						 KZ_PROFILE_VALUE_TYPE_STRING);
    cut_assert_equal_int(1, n_changed_received);
    cut_assert_equal_string("Global", actual_section);
    cut_assert_equal_string("ui_level", actual_key);
    cut_assert_equal_string("ui_level=beginner", actual_old_value);
}

/*
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
