/***************************************************************************
                          barcodecombo.h  -  description
                             -------------------
    begin                : Son Apr 13 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BARCODECOMBO_H
#define BARCODECOMBO_H

#include <qwidget.h>
#include <kcombobox.h>

#include "mybarcode.h"

/** A combobox that lists all barcode encodign types
  * supported by KBarcode.
  */
class BarcodeCombo : public KComboBox  {
    Q_OBJECT
    public: 
        BarcodeCombo(QWidget *parent=0, const char *name=0);
        ~BarcodeCombo();

        const QString getEncodingType();
        void setEncodingType( const QString & type );
};

class KIntNumInput;
class KLineEdit;
class KPushButton;
#if QT_VERSION >= 0x030100
    class KTextEdit;
#else
    class QTextEdit;
#endif
class QCheckBox;
class QLabel;

/** This widget is used in BarCodeDialog and BarcodeSettingsDlg and
  * allows the user to change the data of a barcodeData struct. This powerful
  * widget is always used when the user has to change some property of
  * a barcode.
  *
  * @see BarCodeDialog, @see BarcodeSettingsDlg
  * @author Dominik Seichter
  */
class BarcodeWidget : public QWidget {
    Q_OBJECT
    public:
        BarcodeWidget(QWidget *parent=0, const char *name=0);
        ~BarcodeWidget() { }

        barcodeData getData() const;
        void setData( const barcodeData b );

        void setStandardEnabled( bool b );
        void setDataEnabled( bool b );

        void defaults();

    private slots:
        void encodingChanged();
        void advanced();
        void changed();

    private:
        BarcodeCombo* comboStandard;
        KLineEdit* data;
#if QT_VERSION >= 0x030100
        KTextEdit* multi;
#else
        QTextEdit* multi;
#endif
        
        KIntNumInput* spinMargin;
        KIntNumInput* spinScale;
        KIntNumInput* spinRotation;
        KIntNumInput* spinCut;
        QCheckBox* checkText;

        KPushButton* buttonAdvanced;

        QLabel* labelStandard;
        QLabel* labelData;

        bool m_enabledata;
        bool m_multi;

        barcodeData barcode;
};

#endif
