
/***************************************************************************
                          kbearsitemanagerdata.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfont.h>
#include "kbearsitemanager.h"
#include "kbearsitemanagertreeview.h"

void  KBearSiteManager::initDialog(){
  this->resize(480,485);
  this->setMinimumSize(0,0);
  siteTreeView= new KBearSiteManagerTreeView( this, "SiteTree");
  siteTreeView->setGeometry(10,10,200,465);
  siteTreeView->setMinimumSize(0,0);
//  QString info = i18n("Treeview over all sites in site list");
//  QToolTip::add(siteTreeView, info );
  QWhatsThis::add(siteTreeView, i18n("Treeview over all sites in site list\n\n"
  									"Here you can rename or remove the sites,\n"
  									"you can also move them with drag and drop.") );

  groupBox= new QGroupBox(this,"");
  groupBox->setGeometry(220,10,250,340);
  groupBox->setMinimumSize(0,0);
  groupBox->setTitle("");

  siteEdit= new QLineEdit(groupBox,"siteEdit");
  siteEdit->setGeometry(10,30,230,20);
  siteEdit->setMinimumSize(0,0);
//  info = i18n("Enter your label for the site here");
//  QToolTip::add( siteEdit, i18n("Enter your label for the site here") );
  QWhatsThis::add( siteEdit, i18n("Enter your label for the site here\n\n"
  													"This name has to be unique.") );
  siteEdit->setFocus();
  siteEdit->setFont(QFont("helvetica", 12, 50));
  siteEdit->setText("");
  siteEdit->setMaxLength(50);

  siteLabel= new QLabel(groupBox,"siteLabel");
  siteLabel->setGeometry(10,10,200,20);
  siteLabel->setMinimumSize(0,0);
  siteLabel->setFixedSize(70,20);
  siteLabel->setText(i18n("Site Label:"));

  hostNameLabel= new QLabel(groupBox,"hostNameLabel");
  hostNameLabel->setGeometry(10,50,200,20);
  hostNameLabel->setMinimumSize(0,0);
  hostNameLabel->setFixedSize(90,20);
  hostNameLabel->setText(i18n("Hostname:"));

  hostNameEdit= new QLineEdit(groupBox,"AddressEdit");
  hostNameEdit->setGeometry(10,70,230,20);
  hostNameEdit->setMinimumSize(0,0);
  hostNameEdit->setFixedSize(230,20);
//  info = i18n("Enter the address for the site here");
//  QToolTip::add( hostNameEdit, info);
  QWhatsThis::add( hostNameEdit, i18n("Enter the address for the site here\n\n"
  															"Something like 'ftp.kde.org' or '127.0.0.1'") );
  hostNameEdit->setText("");

  portLabel= new QLabel(groupBox,"portLabel");
  portLabel->setGeometry(10,100,30,20);
  portLabel->setMinimumSize(0,0);
  portLabel->setFixedSize(30,20);
  portLabel->setText(i18n("Port:"));

  portSpinBox= new QSpinBox(groupBox,"portSpinBox");
  portSpinBox->setGeometry(40,100,60,20);
  portSpinBox->setMinimumSize(0,0);
//  info = i18n("Select port number here");
//  QToolTip::add( portSpinBox, info );
  QWhatsThis::add( portSpinBox, i18n("Select port number here\n\n"
  														"Standard port for FTP is 21") );
  portSpinBox->setRange(1,65335);
  portSpinBox->setValue(21);

  anonymousCheck= new QCheckBox(groupBox,"AnonymousLoginCheckBox");
  anonymousCheck->setGeometry(110,100,130,20);
  anonymousCheck->setMinimumSize(0,0);
//  info = i18n("Check this if you want anonymous login");
//  QToolTip::add( anonymousCheck, i18n("Check this if you want anonymous login") );
  QWhatsThis::add( anonymousCheck, i18n("Check this if you want anonymous login")  );
  anonymousCheck->setText(i18n("Anonymous Login"));
  anonymousCheck->setChecked(false);

  userNameLabel= new QLabel(groupBox,"userNameLabel");
  userNameLabel->setGeometry(10,120,200,20);
  userNameLabel->setMinimumSize(0,0);
  userNameLabel->setText(i18n("User name:"));

  userNameEdit= new QComboBox(true,groupBox,"UserNameComboBox");
  userNameEdit->setGeometry(10,140,230,20);
  userNameEdit->setMinimumSize(0,0);
//  info = i18n("Enter your username here or select anonymous");
//  QToolTip::add( userNameEdit, i18n("Enter your username here or select anonymous") );
  QWhatsThis::add( userNameEdit, i18n("Enter your username here or select anonymous") );
  userNameEdit->insertItem("anonymous",0);

  passwordLabel= new QLabel(groupBox,"PasswordLabel");
  passwordLabel->setGeometry(10,160,200,20);
  passwordLabel->setMinimumSize(0,0);
  passwordLabel->setText(i18n("Password:"));

  passwordEdit= new QLineEdit(groupBox,"passwordEdit");
  passwordEdit->setGeometry(10,180,230,20);
  passwordEdit->setMinimumSize(0,0);
//  info = i18n("Enter your password here");
//  QToolTip::add( passwordEdit, i18n("Enter your password here") );
  QWhatsThis::add( passwordEdit, i18n("Enter your password here") );
  passwordEdit->setText("");

  defaultDirLabel= new QLabel(groupBox,"defaultDirLabel");
  defaultDirLabel->setGeometry(10,200,200,20);
  defaultDirLabel->setMinimumSize(0,0);
  defaultDirLabel->setText(i18n("Default Directory:"));

  defaultDirEdit= new QLineEdit(groupBox,"defaultDirEdit");
  defaultDirEdit->setGeometry(10,220,230,20);
  defaultDirEdit->setMinimumSize(0,0);
//  info = i18n("Enter the default directory on remote host here");
//  QToolTip::add( defaultDirEdit, info );
  QWhatsThis::add( defaultDirEdit, i18n("Enter the default directory for the remote host here") );
  defaultDirEdit->setText("");

  descriptionLabel= new QLabel(groupBox,"descriptionLabel");
  descriptionLabel->setGeometry(10,240,200,20);
  descriptionLabel->setMinimumSize(0,0);
  descriptionLabel->setText(i18n("Description:"));

  descriptionEdit= new QMultiLineEdit(groupBox,"descriptionEdit");
  descriptionEdit->setGeometry(10,260,230,70);
  descriptionEdit->setMinimumSize(0,0);
//  info = i18n("Enter a short descripton of the site");
//  QToolTip::add( descriptionEdit, i18n("Enter a short descripton of the site") );
  QWhatsThis::add( descriptionEdit, i18n("Enter a short descripton of the site")  );
  descriptionEdit->setText("");

  newButton= new QPushButton(this,"newButton");
  newButton->setGeometry(220,355,80,30);
  newButton->setMinimumSize(0,0);
//  info = i18n("Add a new site to site list");
//  QToolTip::add( newButton, info );
  QWhatsThis::add( newButton, i18n("Add a new site to site list") );
  newButton->setText(i18n("New"));

  removeButton= new QPushButton(this,"removeButton");
  removeButton->setGeometry(305,355,80,30);
  removeButton->setMinimumSize(0,0);
//  info = i18n("Remove a site from site list");
//  QToolTip::add( removeButton, info );
  QWhatsThis::add( removeButton, i18n("Remove selected site from site list") );
  removeButton->setText(i18n("Remove"));

  dirButton= new QPushButton(this,"NewdirButton");
  dirButton->setGeometry(390,355,80,30);
  dirButton->setMinimumSize(0,0);
//  info = i18n("Adds a new directory to the site list");
//  QToolTip::add( dirButton, info );
  QWhatsThis::add( dirButton, i18n("Adds a new group to the site list") );
  dirButton->setText(i18n("New group"));

  saveButton= new QPushButton(this,"saveButton");
  saveButton->setGeometry(220,390,125,30);
  saveButton->setMinimumSize(0,0);
//  info = i18n("Save the edited site");
//  QToolTip::add( saveButton, info );
  QWhatsThis::add( saveButton, i18n("Save the edited site\n"
  												"This will overwrite the old one.\n\n"
  												"To add a new site press New button before editing.") );
  saveButton->setText(i18n("Save"));

  cancelButton= new QPushButton(this,"cancelButton");
  cancelButton->setGeometry(350,390,120,30);
  cancelButton->setMinimumSize(0,0);
//  info = i18n("Cancel without saving and exit the SiteManager");
//  QToolTip::add( cancelButton, info );
  QWhatsThis::add( cancelButton, i18n("Cancel without saving and exit the SiteManager") );
  cancelButton->setText(i18n("Cancel"));

  connectButton= new QPushButton(this,"connectButton");
  connectButton->setGeometry(220,425,250,50);
  connectButton->setMinimumSize(0,0);
//  info = i18n("Connect to selected site");
//  QToolTip::add( connectButton, info );
  QWhatsThis::add( connectButton, i18n("Connect to selected site") );
  connectButton->setFont(QFont("helvetica", 20, 50));
  connectButton->setText(i18n("Connect"));
  connectButton->setDefault(true);
  connectButton->setAutoDefault(true);

}
