/***************************************************************************
                          kbearsitemanagermap.cpp  -  description
                             -------------------
    Begin                : Fri Aug 25 2000
    Copyright            : (C) 2000 by Bjrn Sahlstrm
    Email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbearsitemanagermap.h"

//-----------------------------------------------
KBearSiteManagerMap::KBearSiteManagerMap()
	: SiteManagerMap()
{
}
//-----------------------------------------------
KBearSiteManagerMap::~KBearSiteManagerMap(){
}
//-----------------------------------------------
/** @returns the parent name for the specified key */
QString KBearSiteManagerMap::getParent( const QString& key ){
	SiteManagerMapIterator it = SiteManagerMap::find( key );
	if( it != end() )
		return it.data().parent;
	return "";
}
//-----------------------------------------------
SiteInfo* KBearSiteManagerMap::find( const QString& name ){
	SiteManagerMapIterator it = SiteManagerMap::find( name );
	if( it != end() )
		return &(it.data());
	return 0L;
}
//-----------------------------------------------
void KBearSiteManagerMap::reparent( const QString& key, const QString& newParent ){
	SiteInfo* siteInf = find( key );	
	if( siteInf != 0L )
		siteInf->parent = newParent;
}
//-----------------------------------------------
