/***************************************************************************
                          kbeardeletejob.h  -  description
                             -------------------
    begin                : lr apr 27 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARDELETEJOB_H
#define KBEARDELETEJOB_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kurl.h>
#include <kio/jobclasses.h>
#include <kio/global.h>
#include <kio/job.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files

/**
  *@author Bjrn Sahlstrm
  */

class KBearDeleteJob : public KIO::Job {
	Q_OBJECT
public:
	/** */
	KBearDeleteJob( const KURL::List& src, bool shred, bool showProgressInfo );
	/** */
	virtual ~KBearDeleteJob();
	/** */
	KURL::List urls() const { return m_srcList; }
	/** */
	static KBearDeleteJob* del( const KURL::List& src, bool shred, bool showProgressInfo );
	/** */
	void start(unsigned long connID);
signals:
	/** */
	void totalFiles( KIO::Job *, unsigned long files );
	/** */
	void totalDirs( KIO::Job *, unsigned long dirs );
	/** */
	void processedFiles( KIO::Job *, unsigned long files );
	/** */
	void processedDirs( KIO::Job *, unsigned long dirs );
	/** */
	void deleting( KIO::Job *, const KURL& file );
protected slots:
	/** */
	virtual void slotInfoMessage( KIO::Job* job, const QString& message );
	/** */
	void slotEntries( KIO::Job*, const KIO::UDSEntryList& list );
	/** */
	virtual void slotResult( KIO::Job *job );
	/**
	* Forward signal from subjob
	*/
	void slotProcessedSize( KIO::Job*, KIO::filesize_t data_size );
	/** */
	void slotReport();
private:
	void statNextSrc();
	void deleteNextFile();
	void deleteNextDir();
private:
	enum {
			STATE_STATING, STATE_LISTING,
			STATE_DELETING_FILES,
			STATE_DELETING_DIRS
	} state;
	unsigned long m_connID;
	KIO::filesize_t m_totalSize;
	KIO::filesize_t m_processedSize;
	KIO::filesize_t m_fileProcessedSize;
	int m_processedFiles;
	int m_processedDirs;
	int m_totalFilesDirs;
	KURL m_currentURL;
	KURL::List files;
	KURL::List symlinks;
	KURL::List dirs;
	KURL::List m_srcList; // is emptied while deleting
	KURL::List::Iterator m_currentStat;
	QStringList m_parentDirs;
	bool m_shred;
	QTimer *m_reportTimer;
};

#endif
