/***************************************************************************
                          kbear.cpp  -  description
                             -------------------
    begin                : sn jan 13 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrlist.h>
#include <qwhatsthis.h>
#include <qaccel.h>
#include <qtimer.h>
#include <qclipboard.h>
#include <qlcdnumber.h>
#include <qfile.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kconfig.h>
#include <kurl.h>
/////////////////
#include <kaccel.h>
#include <kparts/event.h>
///////////////////////
#include <kaction.h>
#include <kshortcut.h>
#include <kstdaction.h>
#include <kstdaccel.h>
#include <kmessagebox.h>
#include <kstatusbar.h>
#include <kstandarddirs.h>
#include <kdeversion.h>
#include <kapplication.h>
#include <kparts/plugin.h>
#include <ktip.h>
#include <kurldrag.h>
#include <kio/jobclasses.h>
#include <kio/slaveconfig.h>
#include <kmdcodec.h>
#include <kemailsettings.h>

#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbear.h"
#include "resource.h"
#include "kbearmdichildview.h"
#include "kbearquickconnect.h"
#include "kbearsettingsdialog.h"
#include "kbearqueryexit.h"
#include "kbearinfoview.h"
#include "base/kbearconnectionmanager.h"
#include "base/connection.h"

//Initialize static members
KBear* KBear::s_self = 0L;
QString KBear::s_email = QString::null;
//Initialize constants
const int MAX_ACTIVE_TRANSFERS = 53;
//-----------------------------------------------
KBear::KBear()
    : QextMdiMainFrm( 0L, "KBear",WDestructiveClose | WStyle_ContextHelp ),
		m_viewLocal( 0L ),
		m_viewLocalCaption( i18n("Your Local File System" ) ),
		m_childFrameMode( KBear::TileVertically ),
		m_autoChildFrameMode( true ),
		m_partManager( new KParts::PartManager( this, "PartManager" ) ),
		m_rememberTopLevelChildPos( true ),
		m_queueTransfers( false ),
		m_settingsDialog( 0L ),
		m_transferQueue( this, "TransferQueue" ),
		m_disconnectWhenDone( false ),
		m_shutdownWhenDone( false ),
		m_sysShutdownWhenDone( false )
{
	s_self = this;
	setInstance( KGlobal::instance() );

	m_windowListActions.setAutoDelete( true );
	m_dockUndockActions.setAutoDelete( true );

	// we need nested parts in order to embed viewers correctly
	m_partManager->setAllowNestedParts( true );

	initDefaultEmail();
	setCaption( VERSION );
	// a status bar
//	statusBar()->show();

	setupActions();

	setXMLFile("kbearui.rc");

#if (KDE_VERSION > 305)
	setStandardToolBarMenuEnabled( true );
#endif

	createGUI( 0L );


	connect( m_partManager, SIGNAL( activePartChanged( KParts::Part* ) ),
				this, SLOT( createGUI( KParts::Part* ) ) );

  	KToggleAction* act = static_cast<KToggleAction*>(actionCollection()->action(KStdAction::stdName(KStdAction::ShowToolbar )) );
	connect( toolBar("mainToolBar"), SIGNAL( visibilityChanged( bool ) ), act, SLOT( setChecked( bool ) ) );
  	act = static_cast<KToggleAction*>(actionCollection()->action("options_show_help_toolbar") );
  	connect( toolBar("helpToolBar"), SIGNAL( visibilityChanged( bool ) ), act, SLOT( setChecked( bool ) ) );
  	act = static_cast<KToggleAction*>(actionCollection()->action("show_taskbar") );
  	connect( toolBar("TaskBar"), SIGNAL( visibilityChanged( bool ) ), act, SLOT( setChecked( bool ) ) );

	connect( actionCollection(), SIGNAL( actionStatusText(const QString &) ),
             		statusBar(), SLOT( message(const QString &) ) );
	connect( actionCollection(), SIGNAL( clearStatusText() ), statusBar(), SLOT( clear() ) );
  	connect( &m_transferQueue, SIGNAL( transferAdded() ), this, SLOT(slotTransferAdded()) );

	initViewLocal();
	initViewInfo();
//	fillWindowMenu();
	m_trayIcon = new KBearSystemTrayDock( this, "KBearTrayIcon",
						static_cast<KToggleAction*>( action("transfer_disconnect") ),
						static_cast<KToggleAction*>( action("transfer_shutdown") ) );


	setupToolTips();
	setMenuForSDIModeSysButtons( menuBar() );
	readProperties( kapp->config() );
	KTipDialog::showTip( this, "kbear/tips" );

	show();
	applyViewSettings();
	m_infoView->slotLogHiding(); // hide it
	m_infoView->slotTransferHiding(); // hide it
	QApplication::sendPostedEvents();
	if( m_autoChildFrameMode && mdiMode() == QextMdi::ChildframeMode )
		setChildFrameMode( m_childFrameMode ); // auto tile
	statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
KBear::~KBear() {
	kdDebug()<<"KBear::~KBear()="<<this<<endl;
}
//-----------------------------------------------
bool KBear::event( QEvent* e) {
	if( e->type() == QEvent::User) {
		KBearMdiChildView* pWnd = (KBearMdiChildView*)((QextMdiViewCloseEvent*)e)->data();
		if( pWnd != 0L ) {
			pWnd->stop(); // stop listing first
			if( pWnd == m_viewLocal ) {
				// if it's the local fileview we don't close it, just hiding it
				// otherwise the filesyspart gets unloaded
				static_cast<KToggleAction*>(actionCollection()->action("show_local"))->setChecked( false );
				slotOptionsShowViewLocal();
				// for auto tiling
				if( m_autoChildFrameMode && mdiMode() == QextMdi::ChildframeMode )
					QTimer::singleShot( 10, this, SLOT( switchToChildframeMode() ) );
				switchToChildframeMode();
				return false;
			}
	         closeWindow( pWnd);
			// for auto tiling
			if( m_autoChildFrameMode && mdiMode() == QextMdi::ChildframeMode ) {
//				QTimer::singleShot( 10, this, SLOT( switchToChildframeMode() ) );
				switchToChildframeMode();
			}
			return true;
		}
	}
	
	return QextMdiMainFrm::event( e);
}
//-----------------------------------------------
KBear* KBear::self() {
	if( s_self == 0L ) // we only want one instance of KBear
		(void)new KBear();
	return s_self;
}
//-----------------------------------------------
void KBear::resizeEvent( QResizeEvent *e) {
	QextMdiMainFrm::resizeEvent( e);
	setSysButtonsAtMenuPosition();
}
//-----------------------------------------------
bool KBear::queryClose() {
kdDebug()<<"KBear::queryClose()"<<endl;
	kapp->config()->setGroup("General");
	int nOfTransfers = m_infoView->numOfTransfers();
	bool confirm;
	int accept = QDialog::Accepted;
	// do user want to confirm exit on active transfers ?
	if( ( confirm = kapp->config()->readBoolEntry( "Confirm On Exit", true) ) && nOfTransfers > 0 ) {
		KBearQueryExit queryExitDlg( this, "KBearQueryExit", true);
		queryExitDlg.m_numOfTransfers->display( i18n("%1").arg(nOfTransfers) );
		queryExitDlg.m_numOfQueuedTransfers->display( i18n("%1").arg(m_transferQueue.count()));
		queryExitDlg.m_askAgainCheckBox->setChecked( ! confirm );
		accept = queryExitDlg.exec();
		bool confirm = queryExitDlg.m_askAgainCheckBox->isChecked();
		// set 'ask again'  according to users choice
		if ( accept == QDialog::Accepted ) {
			kapp->config()->writeEntry( "Confirm On Exit", ! confirm );
		}
	}
	if( accept == QDialog::Accepted ) {
		// well I guess if we get here it's not first run anymore ;) so lets save that
		kapp->config()->writeEntry( "First Run", false );
	     // we need this inorder to get a valid dock config
		m_infoView->slotLogShowing();
		m_infoView->slotTransferShowing();
		// if user want to save ' run time settings'
		if( kapp->config()->readBoolEntry( "Run Time Settings", true) )
			KBear::saveProperties(kapp->config());

		kapp->config()->sync();

		KBearMdiChildView* childView;
		for(QextMdiChildView *w = m_pWinList->first();w;w= m_pWinList->next()) {
			childView = static_cast<KBearMdiChildView*>(w);
			childView->stop();  // stop any job, listing etc.
		}

		 if( m_mdiMode == QextMdi::TabPageMode ) // this is just to prevent crash on shutdown
			switchToChildframeMode();

#if (KDE_VERSION < 305) || !defined(KDE_VERSION)
		QPtrList<KParts::Plugin> plugins = KParts::Plugin::pluginObjects( this );
		KParts::Plugin* plugin = plugins.last();
		for( ; plugin; plugin = plugins.prev() )
			guiFactory()->removeClient( plugin );
#endif
		return true;
	}	
	return false;
}
//-----------------------------------------------
bool KBear::queryExit() {
kdDebug()<<"KBear::queryExit()"<<endl;
	return close();
}
//-----------------------------------------------
void KBear::initViewLocal() {
	KURL u( QDir::homeDirPath() );
	Connection c( u );
	c.setProtocol( "file" );
	c.setLabel( m_viewLocalCaption );
	m_viewLocal = new KBearMdiChildView( 0L, c );
	QWhatsThis::add( m_viewLocal, i18n("This Window displays your local file system.\n"
												"You can use this to transfer files and folders to or "
												"from a remote host by drag and drop."));


	addWindow( m_viewLocal );

	m_viewLocal->show();
	static_cast<KToggleAction*>(actionCollection()->action("show_local"))->setChecked( true );
	if( m_autoChildFrameMode )
		setChildFrameMode( m_childFrameMode );

	connect( m_viewLocal, SIGNAL( transfer( Transfer* ) ), this, SLOT( slotNewTransfer( Transfer* ) ) );

}
//-----------------------------------------------
void KBear::initViewInfo(){
	QString name( "InfoView" );
	m_infoView = new KBearInfoView( 0L, name );
///////////////
	KDockWidget* pCover = createDockWidget( name, QPixmap(), 0L, "", name );
	pCover->setWidget( m_infoView );
	pCover->manualDock( m_pDockbaseAreaOfDocumentViews, KDockWidget::DockBottom, 70 );
	pCover->show();

//////////////
//	addToolWindow( m_infoView, KDockWidget::DockBottom, this, 70, QString(), name );
	connect( m_infoView, SIGNAL( startTransfer( Transfer* ) ), this, SLOT( slotStartTransfer( Transfer* ) ) );
  	connect( m_infoView, SIGNAL( transfersFinished() ), this, SLOT(slotTransfersFinished()) );
}
//-----------------------------------------------
void KBear::setupActions() {
	actionCollection()->setHighlightingEnabled(true);

	m_childViewMenu = new KActionMenu( i18n("Show Child View &Parts..."), actionCollection(), "child_view_menu" );
	m_mdiModeMenu = new KActionMenu( i18n("MD&I Mode..."), actionCollection(), "window_mdimode_menu" );
	m_tileMenu = new KActionMenu( i18n("&Tile..."), actionCollection(), "window_tile_menu" );
	m_dockUndockMenu = new KActionMenu( i18n("&Dock/Undock..."), actionCollection(), "window_dock_undock_menu" );

	//FTP menu
	KAction* action = KStdAction::openNew( this, SLOT( slotQuickConnect() ), actionCollection(), "quick_connect" );
	action->setText( i18n("Quick &Connect") );
	action->setIcon( "connect_creating" );
	action = KStdAction::close( this, SLOT( slotDisconnect() ), actionCollection(), "close_connection" );
	action->setText( i18n("C&lose Connection") );
	action->setIcon( "connect_no" );
	KStdAction::quit( this, SLOT( slotQuit() ), actionCollection(), KStdAction::stdName(KStdAction::Quit) );

	//Transfer menu
	action = new KToggleAction( i18n("&Disconnect after finished downloading"), 0, this, SLOT( slotToggleDisconnect() ), actionCollection(), "transfer_disconnect" );
	action->setEnabled( false );
	action = new KToggleAction( i18n("&Shutdown after finished downloading"), 0, this, SLOT( slotToggleShutdown() ), actionCollection(), "transfer_shutdown" );
	action->setEnabled( false );

	// Settings menu
	action = new KToggleAction( i18n("Show &Toolbar"), 0, this, SLOT( slotOptionsShowChildToolBar() ), actionCollection(), "show_child_toolbar" );
	m_childViewMenu->insert( action );
	action = new KToggleAction( i18n("Show &Path Toolbar"), 0, this, SLOT( slotOptionsShowChildPathToolBar() ), actionCollection(), "show_child_path_toolbar" );
	m_childViewMenu->insert( action );
	action = new KToggleAction( i18n("Show &Statusbar"), 0, this, SLOT( slotOptionsShowChildStatusBar() ), actionCollection(), "show_child_statusbar" );
	m_childViewMenu->insert( action );
	action = new KToggleAction( i18n("Show &Infobar"), 0, this, SLOT( slotOptionsShowChildInfoBar() ), actionCollection(), "show_child_infobar" );
	m_childViewMenu->insert( action );

	KStdAction::showToolbar(this, SLOT(slotOptionsShowToolbar()), actionCollection(), KStdAction::stdName(KStdAction::ShowToolbar ) );
	new KToggleAction( i18n("Show &Help Toolbar"), 0, this, SLOT(slotOptionsShowHelpToolbar()), actionCollection(), "options_show_help_toolbar" );
	KStdAction::showStatusbar(this, SLOT(slotOptionsShowStatusbar()), actionCollection(), KStdAction::stdName(KStdAction::ShowStatusbar ) );
	new KToggleAction( i18n("Show &Taskbar"), 0, this, SLOT( slot_toggleTaskBar() ), actionCollection(), "show_taskbar" );
	new KToggleAction( i18n("Show Transfer &View"), 0, this, SLOT( slotOptionsShowTransferWindows() ), actionCollection(), "show_transferviews" );
	new KToggleAction( i18n("Show Lo&g View"), 0, this, SLOT( slotOptionsShowLogWindow() ), actionCollection(), "show_logview" );
	new KToggleAction( i18n("Show Your &Local Filesystem"), 0, this, SLOT( slotOptionsShowViewLocal() ), actionCollection(), "show_local" );
	KStdAction::saveOptions(this, SLOT(slotOptionsSaveOptions()), actionCollection(), KStdAction::stdName(KStdAction::SaveOptions) );
	new KAction( i18n("R&un Tip of Today"), "ktip", 0, this, SLOT( slotRunTipOfToday() ), actionCollection(), "help_show_tip" );
	new KAction( i18n("Run &Wizard"), "wizard",0, this, SLOT( slotRunWizard() ), actionCollection(), "wizard" );
	KStdAction::keyBindings(this, SLOT(slotOptionsConfigureKeys()), actionCollection(), KStdAction::stdName(KStdAction::KeyBindings) );
	KStdAction::configureToolbars(this, SLOT(slotOptionsConfigureToolbars()), actionCollection(), KStdAction::stdName(KStdAction::ConfigureToolbars));
	KStdAction::preferences(this, SLOT( slotOptionsSettings() ), actionCollection(), KStdAction::stdName(KStdAction::Preferences));

	// Window menu
	new KAction( i18n("&Close"), 0, this, SLOT( closeActiveView() ), actionCollection(), "window_close" );
	new KAction( i18n("Close &All"), 0, this, SLOT( closeAllViews() ), actionCollection(), "window_close_all" );
	new KAction( i18n("&Minimize All"), 0, this, SLOT( iconifyAllViews() ), actionCollection(), "window_minimize_all" );
	KRadioAction* radioAction = new KRadioAction( i18n("&Toplevel mode"), CTRL+SHIFT+Key_F5, this, SLOT( switchToToplevelMode() ), actionCollection(), "mdimode_toplevel" );
	radioAction->setExclusiveGroup( "mdimode" );
	m_mdiModeMenu->insert( radioAction );
	radioAction = new KRadioAction( i18n("C&hildframe mode"), CTRL+SHIFT+Key_F6, this, SLOT( switchToChildframeMode() ), actionCollection(), "mdimode_childframe" );
	radioAction->setExclusiveGroup( "mdimode" );
	m_mdiModeMenu->insert( radioAction );
	radioAction = new KRadioAction( i18n("Ta&b Page mode"), CTRL+SHIFT+Key_F7, this, SLOT( switchToTabPageMode() ), actionCollection(), "mdimode_tabpage" );
	radioAction->setExclusiveGroup( "mdimode" );
	m_mdiModeMenu->insert( radioAction );

	radioAction = new KRadioAction( i18n("Ca&scade windows"), 0, this, SLOT( cascadeWindows() ), actionCollection(), "tile_cascade" );
	radioAction->setExclusiveGroup( "tiles" );
	m_tileMenu->insert( radioAction );
	radioAction = new KRadioAction( i18n("Cascade &maximized"), 0, this, SLOT( cascadeMaximized() ), actionCollection(), "tile_cascade_maximized" );
	radioAction->setExclusiveGroup( "tiles" );
	m_tileMenu->insert( radioAction );
	radioAction = new KRadioAction( i18n("Expand &vertically"), 0, this, SLOT( expandVertical() ), actionCollection(), "tile_expand_vertical" );
	radioAction->setExclusiveGroup( "tiles" );
	m_tileMenu->insert( radioAction );
	radioAction = new KRadioAction( i18n("Expand &horizontally"), 0, this, SLOT( expandHorizontal() ), actionCollection(), "tile_expand_horizontally" );
	radioAction->setExclusiveGroup( "tiles" );
	m_tileMenu->insert( radioAction );
	radioAction = new KRadioAction( i18n("Tile &non-overlapped"), 0, this, SLOT( tileAnodine() ), actionCollection(), "tile_anodine" );
	radioAction->setExclusiveGroup( "tiles" );
	m_tileMenu->insert( radioAction );
	radioAction = new KRadioAction( i18n("Tile overla&pped"), 0, this, SLOT( tilePragma() ), actionCollection(), "tile_pragma" );
	radioAction->setExclusiveGroup( "tiles" );
	m_tileMenu->insert( radioAction );
	radioAction = new KRadioAction( i18n("Tile v&ertically"), 0, this, SLOT( tileVertically() ), actionCollection(), "tile_vertically" );
	radioAction->setExclusiveGroup( "tiles" );
	m_tileMenu->insert( radioAction );
	
}
//-----------------------------------------------
void KBear::setupToolTips(){
// setup tooltips
	actionCollection()->action( "quick_connect" )->setToolTip( i18n("Open the Quick connect dialog") );
	actionCollection()->action( "close_connection" )->setToolTip( i18n("Close connection in active window") );
	actionCollection()->action( KStdAction::stdName(KStdAction::Quit) )->setToolTip( i18n("Quit the application") );
	actionCollection()->action( KStdAction::stdName(KStdAction::ShowToolbar) )->setToolTip( i18n("Toggle Main Toolbar...") );
	actionCollection()->action( "options_show_help_toolbar" )->setToolTip( i18n("Toggle Help Toolbar...") );
	actionCollection()->action( KStdAction::stdName(KStdAction::ShowStatusbar) )->setToolTip( i18n("Toggle statusbar...") );
	actionCollection()->action( "show_taskbar" )->setToolTip( i18n("Toggle taskbar...") );
	actionCollection()->action( "show_transferviews" )->setToolTip( i18n("Toggle the transfer view...") );
	actionCollection()->action( "show_logview" )->setToolTip( i18n("Toggle the log view...") );
	actionCollection()->action( "show_local" )->setToolTip( i18n("Toggle the local file system window...") );
	actionCollection()->action( "show_child_toolbar" )->setToolTip( i18n("Toggle the childs toolbar...") );
	actionCollection()->action( "show_child_path_toolbar" )->setToolTip( i18n("Toggle the childs path toolbar...") );
	actionCollection()->action( "show_child_statusbar" )->setToolTip( i18n("Toggle the childs statusbar...") );
	actionCollection()->action( "show_child_infobar" )->setToolTip( i18n("Toggle the childs infobar...") );
	actionCollection()->action( "wizard" )->setToolTip( i18n("Run the setup wizard.") );
	actionCollection()->action( "help_show_tip" )->setToolTip( i18n("Run the 'Tip of today' dialog.") );
	actionCollection()->action( KStdAction::stdName(KStdAction::HelpContents) )->setToolTip( i18n("Open the 'KBear Handbook.") );
	actionCollection()->action( KStdAction::stdName(KStdAction::WhatsThis) )->setToolTip( i18n("Switch to 'Whats this' mode.") );

// setup whats this
	actionCollection()->action( "quick_connect" )->setWhatsThis( i18n("Push this button to open a new connection.\n"
                  "You can also select the 'Quick Connect' command from the 'FTP' menu.") );
	actionCollection()->action( "close_connection" )->setWhatsThis( i18n("Push this button to close the active connection.\n"
                  "You can also select the 'Close Connection' command from the 'FTP' menu.") );
	actionCollection()->action( KStdAction::stdName(KStdAction::Quit) )->setWhatsThis( i18n("Push this button to quit the application.\n"
				"You can also select the 'Quit' command from the 'FTP' menu.") );
	actionCollection()->action( "help_show_tip" )->setWhatsThis( i18n("Push this button to run the 'Tip of today' dialog.\n"
                  "You can also select the 'Run Tip of today' command from the 'Settings' menu.") );
	actionCollection()->action( KStdAction::stdName(KStdAction::HelpContents) )->setWhatsThis( i18n("Push this button to open the 'KBear Handbook'.\n"
				"You can also select the 'KBear Handbook' command from the 'Help' menu.") );

	actionCollection()->action( "help_show_tip" )->setShortcut( KShortcut( Key_F10 ) );
	actionCollection()->action( KStdAction::stdName(KStdAction::HelpContents) )->setShortcut( KShortcut( Key_F1 ) );
}
//-----------------------------------------------
void KBear::enableTileActions( bool enable ){
	action("tile_cascade")->setEnabled( enable );
	action("tile_cascade_maximized")->setEnabled( enable );
	action("tile_expand_vertical")->setEnabled( enable );
	action("tile_expand_horizontally")->setEnabled( enable );
	action("tile_anodine")->setEnabled( enable );
	action("tile_pragma")->setEnabled( enable );
	action("tile_vertically")->setEnabled( enable );
}
//-----------------------------------------------
void KBear::saveProperties(KConfig* config ) {
	// the 'config' object points to the session managed
	// config file.  anything you write here will be available
	// later when this app is restored
	QString oldGroup = config->group();

	config->setGroup( "General" );
	config->writeEntry( "Queue Transfers", m_queueTransfers);
	config->writeEntry( "Show System Tray Icon", ! m_trayIcon->isHidden() );
	saveMainWindowSettings( config, "MainWindow" );

	m_viewLocal->saveProperties( config, "View Settings" );

	config->setGroup( "View Options" );
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action("show_logview"));
	config->writeEntry( "Show Log", action->isChecked() );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_local"));
	config->writeEntry( "Show Local", action->isChecked() );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_transferviews"));
	config->writeEntry( "Show Transfer", action->isChecked() );

	config->writeEntry( "MDI mode", mdiMode() );
	config->writeEntry( "Maximized Childframes", isInMaximizedChildFrmMode() );
	config->writeEntry( "ChildFrameMode", m_childFrameMode );
	config->writeEntry( "Auto ChildFrameMode", m_autoChildFrameMode );
	config->writeEntry( "Remember Child Positions", m_rememberTopLevelChildPos );
	if( m_rememberTopLevelChildPos && mdiMode() == QextMdi::ToplevelMode)
		saveTopChildPositions(config);

	writeDockConfig( config, "DockState" );

	config->setGroup( "Child View Options" );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_toolbar"));
	config->writeEntry( "Child ToolBar", action->isChecked() );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_path_toolbar"));
	config->writeEntry( "Child Path ToolBar", action->isChecked() );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_statusbar"));
	config->writeEntry( "Child StatusBar", action->isChecked() );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_infobar"));
	config->writeEntry( "Child InfoBar", action->isChecked() );

	config->setGroup( oldGroup );
	config->sync();
}
//-----------------------------------------------
void KBear::readProperties(KConfig* config) {
	QString oldGroup = config->group();
	config->setGroup( "General" );
	double version = config->readDoubleNumEntry( "Version" );
	if( version < IDS_VERSION ) { // if older version we have to remove the old config file
		QString file = locateLocal( "config", "kbearrc" );
		if( QFile::exists( file ) ) {
			QFile f( file );
			f.remove();
		}			
		config->writeEntry( "Version", IDS_VERSION );
		config->sync();
	}
	config->reparseConfiguration();
	readViewSettings(); // will be applied in slotInit()
	applyWindowSettings();
	applyMixedSettings();

	config->setGroup( "General" );
	if(  config->readBoolEntry( "First Run", true ) ) { // first run, so run the wizard
		m_pTaskBar->setBarPos( KToolBar::Bottom );
		slotRunWizard();
		setGeometry( 50, 50, 640, 520 );
		QApplication::sendPostedEvents();
	}
	else {
		applyMainWindowSettings( config, "MainWindow" );
		if(m_mdiMode == QextMdi::ToplevelMode) {
			m_pDockbaseAreaOfDocumentViews->setDockSite(KDockWidget::DockCorner);
			readDockConfig(config, "DockState");
			m_pDockbaseAreaOfDocumentViews->setDockSite(KDockWidget::DockNone);
		}
		else {
			readDockConfig(config, "DockState");
		}
	}
	config->setGroup( oldGroup );
}
//-----------------------------------------------
void KBear::readViewSettings() {
	QString oldGroup = kapp->config()->group();

	for(QextMdiChildView *w = m_pWinList->first();w;w= m_pWinList->next()) {
		KBearMdiChildView* childView = static_cast<KBearMdiChildView*>(w);		
		childView->readProperties( kapp->config(), "View Settings" );
	}

	kapp->config()->setGroup( "View Options" );
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action("show_logview"));
	action->setChecked( kapp->config()->readBoolEntry( "Show Log", true ) );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_local"));
	action->setChecked( kapp->config()->readBoolEntry( "Show Local", true ) );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_transferviews"));
	action->setChecked( kapp->config()->readBoolEntry( "Show Transfer", true ) );
	kapp->config()->setGroup("MainWindow Toolbar mainToolBar");
	action = static_cast<KToggleAction*>(actionCollection()->action( KStdAction::stdName(KStdAction::ShowToolbar ) ));
	action->setChecked( ! kapp->config()->readBoolEntry("Hidden", false) );

	kapp->config()->setGroup("MainWindow Toolbar helpToolBar");
	action = static_cast<KToggleAction*>(actionCollection()->action("options_show_help_toolbar"));
	action->setChecked( ! kapp->config()->readBoolEntry("Hidden", false) );

	kapp->config()->setGroup("MainWindow Toolbar TaskBar");
	action = static_cast<KToggleAction*>(actionCollection()->action("show_taskbar"));
	action->setChecked( ! kapp->config()->readBoolEntry("Hidden", false) );


	kapp->config()->setGroup( "Child View Options" );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_toolbar"));
	action->setChecked( kapp->config()->readBoolEntry( "Child ToolBar", true ) );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_path_toolbar"));
	action->setChecked( kapp->config()->readBoolEntry( "Child Path ToolBar", true ) );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_statusbar"));
	action->setChecked( kapp->config()->readBoolEntry( "Child StatusBar", true ) );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_infobar"));
	action->setChecked( kapp->config()->readBoolEntry( "Child InfoBar", true ) );

	kapp->config()->setGroup( "General" );
	action = static_cast<KToggleAction*>(actionCollection()->action( KStdAction::stdName(KStdAction::ShowStatusbar ) ));
	action->setChecked( (kapp->config()->readEntry("StatusBar", "Enabled") == "Enabled") );
	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
void KBear::applyViewSettings() {
	slotOptionsShowToolbar();
	slotOptionsShowHelpToolbar();
	slot_toggleTaskBar();
	slotOptionsShowStatusbar();
	slotOptionsShowViewLocal();
	slotOptionsShowLogWindow();
	slotOptionsShowTransferWindows();
	slotOptionsShowChildToolBar();
	slotOptionsShowChildPathToolBar();
	slotOptionsShowChildStatusBar();
	slotOptionsShowChildInfoBar();
}
//-----------------------------------------------
void KBear::applyMixedSettings() {
	QString oldGroup = kapp->config()->group();

	kapp->config()->setGroup( "General" );
	bool sysTrayIcon = kapp->config()->readBoolEntry( "Show System Tray Icon", true);
	slotShowSystemTrayIcon( sysTrayIcon );
	
	m_queueTransfers = kapp->config()->readBoolEntry( "Queue Transfers", false);
	m_disconnectCommand = kapp->config()->readEntry( "Disconnect Command", "kppp -k" );
	m_sysShutdownWhenDone = kapp->config()->readBoolEntry( "System Shutdown", false );

	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
void KBear::applyWindowSettings() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("View Options");
 	m_autoChildFrameMode = kapp->config()->readBoolEntry( "Auto ChildFrameMode", true);
	m_childFrameMode = kapp->config()->readUnsignedNumEntry( "ChildFrameMode", KBear::TileVertically );
	m_rememberTopLevelChildPos = kapp->config()->readBoolEntry( "Remember Child Positions", true);
	int mdiMode = kapp->config()->readNumEntry( "MDI mode", QextMdi::ChildframeMode );
	switch( mdiMode ) {
		case QextMdi::ToplevelMode: {
			switchToToplevelMode();
			break;
		}
		case QextMdi::TabPageMode: {
			switchToTabPageMode();
			break;
		}	
		default: {
			switchToChildframeMode();
			bool maxChildFrmMode = kapp->config()->readBoolEntry( "Maximized Childframes", false);
			if( maxChildFrmMode ) {
				setEnableMaximizedChildFrmMode( maxChildFrmMode );
				if( activeWindow() )
					activeWindow()->maximize();
			}
			else
				setChildFrameMode( m_childFrameMode );
		}
	}
	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
QPopupMenu* KBear::taskBarPopup(QextMdiChildView* pWnd,bool bIncludeWindowPopup ) {
	QPopupMenu* menu = QextMdiMainFrm::taskBarPopup( pWnd, bIncludeWindowPopup );
	KBearMdiChildView* view = static_cast<KBearMdiChildView*>(pWnd);
	QPopupMenu* popup = view->popupMenu();
	if( popup ) {
		menu->insertSeparator();
		menu->insertItem( i18n("Operations"), popup );
	}
	return menu;
}
//-----------------------------------------------
void KBear::setChildFrameMode( unsigned int mode ){
	if( mdiMode() != QextMdi::ChildframeMode )
		return;
	switch( mode ) {
		case KBear::Cascade:
			cascadeWindows();break;
		case KBear::CascadeMaximized:
			cascadeMaximized();break;
		case KBear::ExpandVertical:
			expandVertical();break;
		case KBear::ExpandHorizontal:
			expandHorizontal();break;
		case KBear::AnodinesTile:
			tileAnodine();break;
		case KBear::PragmasTile:
			tilePragma();break;
		case KBear::TileVertically:
			tileVertically();break;
	}
}
//-----------------------------------------------
void KBear::initDefaultEmail() {
	// read default email for use as password on anonymous servers
	kapp->config()->setGroup("General" );
	QString tmp = kapp->config()->readEntry( "Default Email",QString::null );	
	if( ! tmp.isNull() ){
		s_email = tmp;
		return;
	}
	KEMailSettings eDefault;
	s_email = eDefault.getSetting( KEMailSettings::EmailAddress );	
}
//-----------------------------------------------
QString KBear::getMdiChildViewCaption( const QString& capt ) {
	QString result;
	int num = 1;
	QString addStr = QString::null;
	do {
		addStr = ( ( num>1 ) ? (" ("+QString::number(num)+")" ): QString::null ) ;	
		result = capt + addStr;	
		++num;
	}while( findMdiChildViewByName( result ) );	

	return result;	
}
//-----------------------------------------------
KBearMdiChildView * KBear::findMdiChildViewByName(const QString& name ) {
	KBearMdiChildView* childView;
	for(QextMdiChildView *w = m_pWinList->first();w;w= m_pWinList->next()) {
		childView = static_cast<KBearMdiChildView*>(w);	
		if( childView->name() == name )
			return childView;
	}
	return 0L;
}
//-----------------------------------------------
void KBear::saveTopChildPositions(KConfig* config)
{
	QValueList<int> topChildPosition;
	KBearMdiChildView* childView;
	for( QextMdiChildView *w = m_pWinList->first(); w; w = m_pWinList->next())
	{
		childView = static_cast<KBearMdiChildView*>(w);
		QRect rect = childView->geometry();
		topChildPosition.append( rect.x() );
		topChildPosition.append( rect.y() );
		topChildPosition.append( rect.width() );
		topChildPosition.append( rect.height() );
	}

	config->writeEntry("Child Position Toplevel", topChildPosition);
}
//-----------------------------------------------
void KBear::readTopChildPositionFromIndex(unsigned int index)
{
	QValueList<int> topChildPosition;
	KConfig* config = kapp->config();
	config->setGroup( "View Options" );
	topChildPosition = config->readIntListEntry("Child Position Toplevel");

	KBearMdiChildView* child = static_cast<KBearMdiChildView*>( m_pWinList->at(index) );

	if(topChildPosition.count() > index * 4)
	{
		child->setGeometry( topChildPosition[4 * index],		// X
										    topChildPosition[4 * index+1],  // Y
				  							topChildPosition[4 * index+2],  // width
												topChildPosition[4 * index+3]); // height
	}
	else
	{
		child->setGeometry( 10, 10, 300, 400 );
	}
}
//-----------------------------------------------
void KBear::readAllTopChildPositions()
{
	for(unsigned int i = 0; i < m_pWinList->count(); ++i)	
		readTopChildPositionFromIndex(i);
}
//-----------------------------------------------
QString KBear::decodePassword( const QString& pass ) {
	QString p = pass;
	QCString dataIn;
	QTextStream sStream( &p, IO_ReadOnly );
	sStream >> dataIn;
	QCString result = KCodecs::base64Decode( dataIn );
	return result.data();
}
//-----------------------------------------------
QString KBear::encodedEmail() {
	return encodePassword( s_email );
}
//-----------------------------------------------
QString KBear::encodePassword( const QString& password ) {
	QString pass = password;
	QTextStream sStream( &pass, IO_ReadOnly );
	QCString bArray;
	sStream >> bArray;
	QCString result = KCodecs::base64Encode( bArray, true );	
	return result.data();
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbear.moc"
#endif
