/***************************************************************************
                          kbearquickconnect.h  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KBEAR_QUICKCONNECT_H
#define KBEAR_QUICKCONNECT_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qwidget.h>
#include <qcheckbox.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kdialog.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "base/kbearquickconnectbase.h"

class Connection;

/**
  *@author Bjrn Sahlstrm
  **/

class KBearQuickConnect : public KBearQuickConnectBase  {
   Q_OBJECT
public: 
	KBearQuickConnect(QWidget *parent=0, const char *name=0);
	~KBearQuickConnect();
	const bool saveSite() const { return m_saveToSiteManagerCheckBox->isChecked(); }

signals:
	void openConnection( const Connection& );
	void saveToSiteManager( const Connection& );
protected slots: // Protected slots
	/** close the quick connect dialog**/
	virtual void reject();
	/** close the quick connect dialog and open a connection to selected host**/
	virtual void accept();
	/** */
	virtual void slotSetAnonymous();
	/** Automatically updates the port combo depending on selected protocol */
	void slotSelectedProtocol( const QString& protocol );
private:
	bool m_hasKBearFTP;
};

#endif
