/***************************************************************************
                          kbearsplash.cpp  -  description
                             -------------------
    begin                : ons aug 14 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstring.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qapplication.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kwin.h>
#include <kstandarddirs.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsplash.h"

#include "kbearsplash.moc"
//-----------------------------------------------
KBearSplash::KBearSplash()
 : QVBox( 0L, "KBear Splash", WStyle_NoBorder | WStyle_Customize | WDestructiveClose )
{
	KWin::setState( winId(), NET::SkipTaskbar | NET::SkipPager );
	setFrameStyle( QFrame::NoFrame );
	setGeometry( QApplication::desktop()->width ()/2-200,
 						    	QApplication::desktop()->height()/2-150, 400, 300 );
	setFixedSize( 400, 300 );

	QString text = i18n( "A Graphical FTP Client for KDE" );

	QString f = locate( "appdata", "kbear-logo-top.jpg" );
	m_topPix = new QPixmap( f );
	f = locate( "appdata", "kbear-logo-bottom.jpg" );
	m_bottomPix = new QPixmap( f );
//	setPaletteBackgroundPixmap( pm );

	QLabel* splashTop = new QLabel( this, "SplashTop");
	splashTop->setBackgroundMode(NoBackground);
	splashTop->setPixmap( *m_topPix );

	QLabel* splashBottom = new QLabel( text, this, "SplashBottom");
	splashBottom->setAlignment( Qt::AlignTop | Qt::AlignHCenter );
	splashBottom->setPaletteBackgroundPixmap( *m_bottomPix );
//	splashText->setBackgroundOrigin( ParentOrigin );
	splashBottom->setPaletteForegroundColor( QColor( 255, 242, 32 ) );
	QFont splashBottom_font(  splashBottom->font() );
	splashBottom_font.setBold( true );
	int xpos = -1;
	for( int i = 24; i > 8 && xpos < 0; i -= 2 ) { // we have to make sure the localized text is fitted into splash
		splashBottom_font.setPointSize( i );
		splashBottom->setFont( splashBottom_font );
		xpos = (400 - splashBottom->fontMetrics().width( text ) ) / 2;
	}
	splashTop->show();
	splashBottom->show();
}
//-----------------------------------------------
KBearSplash::~KBearSplash() {
	delete m_topPix;
	delete m_bottomPix;
}
//-----------------------------------------------
void KBearSplash::raise() {
	QWidget::raise();
	repaint();
	QApplication::flushX();
}
//-----------------------------------------------
void KBearSplash::show() {
	QWidget::show();
	raise();
	QApplication::sendPostedEvents();
}
//-----------------------------------------------
