/***************************************************************************
                          kbeartransferview.cpp  -  description
                             -------------------
    begin                : lr maj 05 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


//////////////////////////////////////////////////////
// Qt specific includes

//////////////////////////////////////////////////////
// KDE specific includes
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartransferview.h"
#include "base/kbeartransferviewpage.h"
#include "base/transfer.h"


//-----------------------------------------------
KBearTransferView::KBearTransferView(QWidget *parent, const QString& name )
	: KBearTabView( parent, name.latin1() )
{
}
//-----------------------------------------------
KBearTransferView::~KBearTransferView(){
}
//-----------------------------------------------
bool KBearTransferView::canStartTransfer( const QString& name, const QString& other ) {
	int p = findTabByCaption( name );
	if( p != -1 ) {
		KBearTransferViewPage* tPage = static_cast<KBearTransferViewPage*>( page( p ) );
		if( tPage->numOfTransfers() > 0 ) {
			return false;
		}
	}
	else {
		p = findTabByCaption( other );
		if( p != -1 ) {
			KBearTransferViewPage* tPage = static_cast<KBearTransferViewPage*>( page( p ) );
			if( tPage->checkActiveTransfer( name ) ) {
				return false;
			}
		}
	}
	return true;
}
//-----------------------------------------------
void KBearTransferView::addTransfer( Transfer* transfer ){
	QString name;
	if( ! transfer->sourceList().first().hasHost() ) { // dest is remote
		name = transfer->destConnection().label();
	}
	else { // either source is remote or boths source and dest are remote
		name = transfer->sourceConnection().label();
	}

	int tabNr = findTabByCaption( name );
	if( tabNr == -1 ) { // create new page
		addPage( name );
	}

	tabNr = findTabByCaption( name );
	KBearTransferViewPage* w = static_cast<KBearTransferViewPage*>( page( tabNr ) );	
	w->addTransfer( transfer );	
}
//-----------------------------------------------
void KBearTransferView::addPage( const QString& name ){
	KBearTransferViewPage* w = new KBearTransferViewPage( this, name );
	addTab( w, name );
	showPage( w );
	KBearTabView::addPage( name );
	connect( w, SIGNAL( remove( const QString& ) ), this, SLOT( slotRemovePage( const QString& ) ) );
	connect( w, SIGNAL( start( Transfer* ) ), SIGNAL( start( Transfer* ) ) );
}
//-----------------------------------------------
void KBearTransferView::slotRemovePage( const QString& name ) {
	removePage( name );
}
//-----------------------------------------------
int KBearTransferView::numOfTransfers() const {
	int nTrans = 0;
	for( int i = 0; i < count(); ++i ) {
		KBearTransferViewPage* tPage= static_cast<KBearTransferViewPage*>( page( i ) );
		nTrans += tPage->numOfTransfers();
	}
	return nTrans;
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbeartransferview.moc"
#endif
