/***************************************************************************
                          kbearwizard.cpp  -  description
                             -------------------
    begin                : Wed Jul 19 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kapplication.h>
#include <kconfig.h>
#include <kedittoolbar.h>
#include <kkeydialog.h>
#include <klocale.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearwizard.h"
#include "resource.h"
//#include "kbear.h"
#include "viewsettingswidget.h"
#include "mixedsettingswidget.h"
#include "windowsettingswidget.h"
#include "firewallsettingswidget.h"

//-----------------------------------------------
KBearWizard::KBearWizard(QWidget *p, const char *name )
	: KBearWizardBase( p, name, true )
{
	//setup the GUI
////////////////////////////////////////////////////////////////////
// Page 0 already added
////////////////////////////////////////////////////////////////////
// Page 1
	addPage(  new ViewSettingsWidget( this, "ViewSettings" ), i18n("View Settings") );
////////////////////////////////////////////////////////////////////
// Page 2
	addPage( new WindowSettingsWidget( this, "WindowSettings" ), i18n("Window Settings") );
////////////////////////////////////////////////////////////////////
// Page 3
	addPage( new MixedSettingsWidget( this, "MixedSettings" ), i18n("Miscellaneous Settings") );
////////////////////////////////////////////////////////////////////
// Page 4
	addPage( new FirewallSettingsWidget( this, "FirewallSettings" ), i18n("Firewall Settings") );
////////////////////////////////////////////////////////////////////
// Page 5
//	addPage( new KKeyChooser( KBear::self()->actionCollection(), this ), i18n("Configure Key Bindings") );
////////////////////////////////////////////////////////////////////
	setHelpEnabled( page(1), true );
	setHelpEnabled( page(2), true );
	setHelpEnabled( page(3), true );
	setHelpEnabled( page(4), true );
	setFinishEnabled( page(4), true );
}
//-----------------------------------------------
KBearWizard::~KBearWizard(){
}
//-----------------------------------------------
/*
void KBearWizard::next(){
// When switching to next paeg we want to apply the settings
kdDebug()<<"KBearWizard::next() current="<<indexOf( currentPage() )<<endl;
	switch( indexOf( currentPage() ) ) {
		case 1: //View settings
			static_cast<ViewSettingsWidget*>( page( 1 ) )->saveSettings();
			KBear::self()->applyViewSettings();
			break;
		case 2: //Window settings
			static_cast<WindowSettingsWidget*>( page( 2 ) )->saveSettings();
			KBear::self()->applyWindowSettings();
			break;
		case 3: //Mixed settings
			static_cast<MixedSettingsWidget*>( page( 3 ) )->saveSettings();
			KBear::self()->applyMixedSettings();
			break;
	}

	KBearWizardBase::next();
}
*/
//-----------------------------------------------
void KBearWizard::help(){
// here we point help to different sections depending on which page is chown
	QString section;
	switch( indexOf( currentPage() ) ) {
		case 1: //View settings
			section = "view-settings";
			break;
		case 2: //Window settings
			section = "window-settings";
			break;
		case 3: //Mixed settings
			section = "misc-settings";
			break;
		case 4: //Firewall settings
			section = "firewall-settings";
			break;
		default:
			section = "configure-kbear";
			break;
	}
	KApplication::kApplication()->invokeHelp( section, "kbear");
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearwizard.moc"
#endif
