/***************************************************************************
                          mixedsettingswidget.cpp  -  description
                             -------------------
    begin                : tor feb 28 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qcheckbox.h>
#include <qradiobutton.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "mixedsettingswidget.h"
#include "resource.h"
#include "kbear.h"

//-----------------------------------------------
MixedSettingsWidget::MixedSettingsWidget( QWidget *parent, const char *name)
	: MixedSettingsBase(parent,name)
{
	readSettings();
}
//-----------------------------------------------
MixedSettingsWidget::~MixedSettingsWidget(){
}
//--------------------------------------------
void MixedSettingsWidget::setDefaultEmail( const QString& email ){
	QString tmp = QString::null;
	// read default email for use as password on anonymous servers
	KConfig* conf =  new KConfig("emaildefaults");
	QStringList groupList = conf->groupList();
	for( QStringList::Iterator it = groupList.begin(); it != groupList.end(); it++ ) {
		conf->setGroup( (*it) );
		tmp = conf->readEntry( "EmailAddress" );
		if( ! tmp.isNull() ) {
			p_emailComboBox->insertItem( tmp );
		}
	}
	if( ! email.isNull() ) {
		p_emailComboBox->setCurrentItem( email, true );
	}
	delete conf;
}
//-----------------------------------------------
void MixedSettingsWidget::readSettings() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("General");
	p_showSystemTrayCheckBox->setChecked( kapp->config()->readBoolEntry( "Show System Tray Icon", true) );
	p_confirmExitCheckBox->setChecked( kapp->config()->readBoolEntry( "Confirm On Exit", true) );
	p_queueTransferCheckBox->setChecked( kapp->config()->readBoolEntry( "Queue Transfers", false) );
	m_disconnectCommandLineEdit->setText( kapp->config()->readEntry( "Disconnect Command", "kppp -k" ) );
	m_sysShutdownCheckBox->setChecked( kapp->config()->readBoolEntry( "System Shutdown", false ) );

	unsigned int viewMode = kapp->config()->readUnsignedNumEntry( "Preview Mode", ReadOnly );
	switch( viewMode ) {
		case ReadOnly:
			p_readOnlyButton->setChecked( true );
			break;
		case ReadWrite:
			p_readWriteButton->setChecked( true );
			break;
		case Ask:
			p_askButton->setChecked( true );
			break;
	}
			

	setDefaultEmail( KBear::email() );

	kapp->config()->setGroup("TipOfDay");
	p_runTipCheckBox->setChecked( kapp->config()->readBoolEntry( "RunOnStart", true) );
	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
void MixedSettingsWidget::saveSettings() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("General");
	kapp->config()->writeEntry( "Show System Tray Icon", p_showSystemTrayCheckBox->isChecked() );
	kapp->config()->writeEntry( "Confirm On Exit", p_confirmExitCheckBox->isChecked() );
	kapp->config()->writeEntry( "Queue Transfers", p_queueTransferCheckBox->isChecked() );
	kapp->config()->writeEntry( "Disconnect Command", m_disconnectCommandLineEdit->text() );
	kapp->config()->writeEntry( "System Shutdown", m_sysShutdownCheckBox->isChecked() );

	if( p_emailComboBox->currentText() != "" ) {
		kapp->config()->writeEntry( "Default Email", p_emailComboBox->currentText() );
		KBear::setEmail( p_emailComboBox->currentText() );
	}
	if( p_readWriteButton->isChecked() )
		kapp->config()->writeEntry( "Preview Mode", ReadWrite );		
	else if( p_askButton->isChecked() )
		kapp->config()->writeEntry( "Preview Mode", Ask );	
	else	
		kapp->config()->writeEntry( "Preview Mode", ReadOnly );	

	kapp->config()->setGroup("TipOfDay");
	kapp->config()->writeEntry( "RunOnStart", p_runTipCheckBox->isChecked() );
	kapp->config()->setGroup( oldGroup );
	kapp->config()->sync();
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "mixedsettingswidget.moc"
#endif

