/***************************************************************************
                          siteimportdialog.cpp  -  description
                             -------------------
    begin                : tis mar 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdir.h>
#include <qfile.h>
#include <qptrlist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kprogress.h>
#include <klocale.h>
#include <kglobal.h>
#include <klibloader.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kparts/plugin.h>
#include <kfiledialog.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteimportdialog.h"
#include "../../base/siteimportfilterpluginiface.h"

//-----------------------------------------------
SiteImportDialog::SiteImportDialog(QWidget *parent, const char *name )
	:	SiteImportDialogBase(parent,name),
		m_importPlugin( 0L )
{
	m_pluginList = KTrader::self()->query("KBear/ImportFilter");
	KTrader::OfferList::Iterator it( m_pluginList.begin() );
	for( ; it != m_pluginList.end(); ++it ) {
		KService::Ptr ptr = (*it);
		QListViewItem* item = new QListViewItem( m_availableFiltersListView, ptr->name() );	
		item->setPixmap( 0, KGlobal::iconLoader()->loadIcon("filter", KIcon::Small ) );
		item->setExpandable( false );
/*
	QValueList<KParts::Plugin::PluginInfo>::iterator it;
	for( it = m_pluginList.begin(); it != m_pluginList.end(); ++it ) {
		QDomElement e = (*it).m_document.documentElement();
		QListViewItem* item = new QListViewItem( m_availableFiltersListView, e.attribute( "name" ) );	
		item->setPixmap( 0, KGlobal::iconLoader()->loadIcon("filter", KIcon::Small ) );
		item->setExpandable( false );
*/
	}	
}
//-----------------------------------------------
SiteImportDialog::~SiteImportDialog(){
}
//-----------------------------------------------
void SiteImportDialog::slotImport(){
	if( ! m_availableFiltersListView->selectedItem() ) // no selected filter
		return;
	KTrader::OfferList::Iterator it( m_pluginList.begin() );
	for( ; it != m_pluginList.end(); ++it ) {
		KService::Ptr ptr = (*it);
		if( m_availableFiltersListView->selectedItem()->text(0) ==  ptr->name() ) {	
			QString fileName = ptr->property( "X-KBear-ImportFile" ).toString();
			// check if we was given a filename
			if( ! fileName.isEmpty() ) {  // we were given a file name, so lets try to locate the file
				KGlobal::dirs()->addResourceDir( "HOME", QDir::homeDirPath() );
				QString tmp = fileName;
				fileName = locate( "data", tmp );
				if( fileName.isEmpty() ) {// not found in data
					fileName = locate( "appdata", tmp ); // so try in data
					if( fileName.isEmpty() ) {// not found in appdata
						fileName = locate( "config", tmp );  // so try in config
						if( fileName.isEmpty() ) {// not found in config
							fileName = locate( "HOME", tmp ); // so try in HOME
						}
					}
				}
			}
			if( fileName.isEmpty() ) {
				fileName = KFileDialog::getOpenFileName( QDir::homeDirPath(), QString::null, this,
													i18n("Select file to import with %1").arg(ptr->name()) );
			}
			if( ! fileName.isEmpty() ) {
                   KLibFactory* factory = KLibLoader::self()->factory( ptr->library() );
				if( factory ) {
					SiteImportFilterPluginIface* plugin = static_cast<SiteImportFilterPluginIface*>(factory->create( this, "ImportFilter", "KParts::Plugin" ));
					if( plugin )
						startImport( plugin, fileName );
				}
			}
		}
	}	
}
//-----------------------------------------------
void SiteImportDialog::startImport( SiteImportFilterPluginIface* importPlugin, const QString& fileName ) {
	m_importPlugin = importPlugin;
	connect( importPlugin, SIGNAL( progress( int ) ), this, SLOT( slotProgress( int ) ) );
	m_progress->setValue( 0 );
	importPlugin->import( fileName );
}
//-----------------------------------------------
void SiteImportDialog::slotProgress( int progress ) {
	m_progress->setProgress( progress );
	if( progress == 100 ) {
		// When we get here the import should be done so lets fetch the dom tree
		if( ! m_importPlugin->hasError() )  {
			emit importSites( m_importPlugin->getDomDocument() );
		}
		delete m_importPlugin;
		m_progress->setValue( 0 );
	}
}
//-----------------------------------------------
void SiteImportDialog::slotSelectionChanged(){
	m_buttonImport->setEnabled( m_availableFiltersListView->selectedItem() );
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "siteimportdialog.moc"
#endif
