/***************************************************************************
                          siteimportdialog.h  -  description
                             -------------------
    begin                : tis mar 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SITEIMPORTDIALOG_H
#define SITEIMPORTDIALOG_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qvaluelist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kdialog.h>
#include <kservice.h>
#include <ktrader.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteimportdialogbase.h"

class SiteImportFilterPluginIface;
class KBearSiteManager;

/**
  *@author Bjrn Sahlstrm
  */

class SiteImportDialog : public SiteImportDialogBase  {
   Q_OBJECT
public: 
	/** */
	SiteImportDialog(QWidget* parent, const char *name );
	/** */
	~SiteImportDialog();
	/** */
	void startImport( SiteImportFilterPluginIface* importPlugin, const QString& fileName );
	/** */
	QValueList<KService::Ptr>& pluginList() { return m_pluginList; }
signals:
	void importSites( const QString& );
protected slots:
	/** */
	virtual void slotImport();
	/** */
	virtual void slotSelectionChanged();
private slots:
	void slotProgress( int );
private:
	QValueList<KService::Ptr> m_pluginList;
	SiteImportFilterPluginIface* m_importPlugin;
};

#endif
