/******************************************************************************
 *   Copyright (C) 2006 PhobosK <phobosk@mail.kbfx.org>                       *
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This package is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this package; if not, write to the Free Software              *
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA *
 ******************************************************************************/

#include "kbfxthemesdata.h"

KbfxThemesData::KbfxThemesData()
{
}

KbfxThemesData::~KbfxThemesData()
{
  m_themesMap.clear();
}

ThemesMap KbfxThemesData::setThemeList(QString path)
{
  m_themesMap.clear();

  KStandardDirs *tmp = new KStandardDirs();

  /* search themes in KDE Resource Folders and append user selected folder */
  QStringList skinsFolders = tmp->findDirs("data", "kbfx/skins");
  skinsFolders.append(path);

  for(QStringList::Iterator skinsIt = skinsFolders.begin(); skinsIt != skinsFolders.end(); ++skinsIt)
  {
    QDir d(*skinsIt);
    d.setFilter(QDir::Dirs);

    const QFileInfoList *list = d.entryInfoList();
    QFileInfoListIterator it(*list);
    QFileInfo *fi;

    while((fi = it.current()) != 0)
    {
      if(!fi->fileName().contains("."))
        m_themesMap[fi->fileName()] = (fi->dirPath(TRUE)).append("/");

      ++it;
    }
  }

  /* kdDebug() << "Available Themes - "
   *           << m_themesMap.keys()
   *           << m_themesMap.values()
   *           << endl;
   */

  return m_themesMap;
}
